/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzbwz;
import com.google.android.gms.internal.zzbyf;
import com.google.android.gms.internal.zzcak;
import com.google.android.gms.internal.zzcam;
import com.google.android.gms.internal.zzcap;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzhiq;

    public FitnessSensorService() {
    }

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzhiq = new zza(this, null);
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                String string = String.valueOf(intent);
                String string2 = ((Object)((Object)this)).getClass().getName();
                Log.d((String)"FitnessSensorService", (String)new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Intent ").append(string).append(" received by ").append(string2).toString());
            }
            return this.zzhiq.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    @TargetApi(value=19)
    protected final void zzaqz() throws SecurityException {
        int n = Binder.getCallingUid();
        if (zzq.zzaml()) {
            ((AppOpsManager)this.getSystemService("appops")).checkPackage(n, "com.google.android.gms");
            return;
        }
        String[] stringArray = this.getPackageManager().getPackagesForUid(n);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!stringArray2[i].equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    static final class zza
    extends zzcap {
        private final FitnessSensorService zzhir;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzhir = fitnessSensorService;
        }

        @Override
        public final void zza(zzcak zzcak2, zzbwz zzbwz2) throws RemoteException {
            this.zzhir.zzaqz();
            List<DataSource> list = this.zzhir.onFindDataSources(zzcak2.getDataTypes());
            zzbwz2.zza(new DataSourcesResult(list, Status.zzfni));
        }

        @Override
        public final void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzbyf zzbyf2) throws RemoteException {
            this.zzhir.zzaqz();
            if (this.zzhir.onRegister(fitnessSensorServiceRequest)) {
                zzbyf2.zzn(Status.zzfni);
                return;
            }
            zzbyf2.zzn(new Status(13));
        }

        @Override
        public final void zza(zzcam zzcam2, zzbyf zzbyf2) throws RemoteException {
            this.zzhir.zzaqz();
            if (this.zzhir.onUnregister(zzcam2.getDataSource())) {
                zzbyf2.zzn(Status.zzfni);
                return;
            }
            zzbyf2.zzn(new Status(13));
        }

        /* synthetic */ zza(FitnessSensorService fitnessSensorService, com.google.android.gms.fitness.service.zza zza2) {
            this(fitnessSensorService);
        }
    }
}

