/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.zzf;
import com.google.android.gms.fitness.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FitnessOptions
implements GoogleSignInOptionsExtension,
Api.ApiOptions.HasGoogleSignInAccountOptions {
    public static final int ACCESS_READ = 0;
    public static final int ACCESS_WRITE = 1;
    private final Map<Integer, List<DataType>> zza;
    private final Set<Scope> zzb;
    private final GoogleSignInAccount zzc;

    private FitnessOptions(Map<Integer, List<DataType>> map, GoogleSignInAccount googleSignInAccount) {
        this.zza = map;
        this.zzc = googleSignInAccount;
        ArrayList<Scope> arrayList = new ArrayList<Scope>();
        for (Map.Entry<Integer, List<DataType>> entry : map.entrySet()) {
            for (DataType dataType : entry.getValue()) {
                if (entry.getKey() == 0 && dataType.zza() != null) {
                    arrayList.add(new Scope(dataType.zza()));
                    continue;
                }
                if (entry.getKey() != 1 || dataType.zzb() == null) continue;
                arrayList.add(new Scope(dataType.zzb()));
            }
        }
        this.zzb = zzg.zza(arrayList);
    }

    @Hide
    public GoogleSignInAccount getGoogleSignInAccount() {
        return this.zzc;
    }

    public int getExtensionType() {
        return 3;
    }

    public Bundle toBundle() {
        return new Bundle();
    }

    @Nullable
    public List<Scope> getImpliedScopes() {
        return new ArrayList<Scope>(this.zzb);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    @Hide
    public static Builder zza(GoogleSignInAccount googleSignInAccount) {
        if (googleSignInAccount != null) {
            return new Builder(null).zza(googleSignInAccount);
        }
        return new Builder(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FitnessOptions fitnessOptions = (FitnessOptions)object;
        return zzbg.zza(this.zza, fitnessOptions.zza) && zzbg.zza((Object)this.zzc, (Object)fitnessOptions.zzc);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzc});
    }

    /* synthetic */ FitnessOptions(Map map, GoogleSignInAccount googleSignInAccount, zzf zzf2) {
        this(map, googleSignInAccount);
    }

    public static final class Builder {
        private final Map<Integer, List<DataType>> zza = new HashMap<Integer, List<DataType>>();
        private GoogleSignInAccount zzb;

        private Builder() {
        }

        public final Builder addDataType(@NonNull DataType dataType) {
            return this.addDataType(dataType, 0);
        }

        public final Builder addDataType(@NonNull DataType dataType, int n) {
            zzbq.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"valid access types are FitnessOptions.ACCESS_READ or FitnessOptions.ACCESS_WRITE");
            List<DataType> list = this.zza.get(n);
            if (list == null) {
                list = new ArrayList<DataType>();
                this.zza.put(n, list);
            }
            list.add(dataType);
            return this;
        }

        @Hide
        private final Builder zza(@NonNull GoogleSignInAccount googleSignInAccount) {
            this.zzb = googleSignInAccount;
            return this;
        }

        public final FitnessOptions build() {
            return new FitnessOptions(this.zza, this.zzb, null);
        }

        /* synthetic */ Builder(zzf zzf2) {
            this();
        }
    }
}

