/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbwm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends zzbgl
implements ReflectedParcelable {
    private final int zza;
    private final DataSource zzb;
    private final List<DataPoint> zzc;
    private final List<DataSource> zzd;
    private boolean zze = false;
    @Hide
    public static final Parcelable.Creator<DataSet> CREATOR = new zzi();

    @Hide
    DataSet(int n, DataSource dataSource, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.zza = n;
        this.zzb = dataSource;
        this.zze = bl;
        this.zzc = new ArrayList<DataPoint>(list.size());
        this.zzd = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzc.add(new DataPoint(this.zzd, rawDataPoint));
        }
    }

    @Hide
    private DataSet(DataSource dataSource) {
        this.zza = 3;
        this.zzb = (DataSource)((Object)zzbq.zza((Object)((Object)dataSource)));
        this.zzc = new ArrayList<DataPoint>();
        this.zzd = new ArrayList<DataSource>();
        this.zzd.add(this.zzb);
    }

    @Hide
    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.zza = 3;
        this.zzb = list.get(rawDataSet.zza);
        this.zzd = list;
        this.zze = rawDataSet.zzc;
        List<RawDataPoint> list2 = rawDataSet.zzb;
        this.zzc = new ArrayList<DataPoint>(list2.size());
        for (RawDataPoint rawDataPoint : list2) {
            this.zzc.add(new DataPoint(this.zzd, rawDataPoint));
        }
    }

    public static DataSet create(DataSource dataSource) {
        zzbq.zza((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public final DataPoint createDataPoint() {
        return DataPoint.create(this.zzb);
    }

    public final void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzbq.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzb.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzb});
        dataPoint.zze();
        DataSet.zza(dataPoint);
        this.zzb(dataPoint);
    }

    @Hide
    private final void zzb(DataPoint dataPoint) {
        this.zzc.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzd.contains((Object)dataSource)) {
            this.zzd.add(dataSource);
        }
    }

    public final void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    @Hide
    public final void zza(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public final DataSource getDataSource() {
        return this.zzb;
    }

    public final DataType getDataType() {
        return this.zzb.getDataType();
    }

    public final List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzc);
    }

    public final boolean isEmpty() {
        return this.zzc.isEmpty();
    }

    @Hide
    public final boolean zza() {
        return this.zze;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DataSet)) {
            return false;
        }
        DataSet dataSet = (DataSet)((Object)object);
        return zzbg.zza((Object)((Object)this.zzb), (Object)((Object)dataSet.zzb)) && zzbg.zza(this.zzc, dataSet.zzc) && this.zze == dataSet.zze;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzb});
    }

    public final String toString() {
        List<RawDataPoint> list = this.zzb();
        return String.format("DataSet{%s %s}", this.zzb.zzb(), this.zzc.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzc.size(), list.subList(0, 5)));
    }

    @Hide
    public static void zza(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzbwm.zza(dataPoint, zzf.zza);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    @Hide
    private List<RawDataPoint> zzb() {
        return this.zza(this.zzd);
    }

    @Hide
    final List<RawDataPoint> zza(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzc.size());
        for (DataPoint dataPoint : this.zzc) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSet dataSet = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)dataSet.getDataSource(), (int)n, (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)3, dataSet.zzb(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, dataSet.zzd, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (boolean)dataSet.zze);
        zzbgo.zza((Parcel)parcel2, (int)1000, (int)dataSet.zza);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

