/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.data.zzk;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgq;

public class DataSource
extends zzbgl {
    private static final int[] zza = new int[0];
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_ESH2002 = 1;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_ESH2010 = 2;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_AAMI = 3;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_A_A = 4;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_A_B = 5;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_B_A = 6;
    public static final int DATA_QUALITY_BLOOD_PRESSURE_BHS_B_B = 7;
    public static final int DATA_QUALITY_BLOOD_GLUCOSE_ISO151972003 = 8;
    public static final int DATA_QUALITY_BLOOD_GLUCOSE_ISO151972013 = 9;
    private final DataType zzb;
    @Nullable
    private final String zzc;
    private final int zzd;
    @Nullable
    private final Device zze;
    @Nullable
    private final zzb zzf;
    @Nullable
    private final String zzg;
    private final int[] zzh;
    private final String zzi;
    @Hide
    public static final Parcelable.Creator<DataSource> CREATOR = new zzk();

    @Hide
    DataSource(DataType dataType, @Nullable String string, int n, @Nullable Device device, @Nullable zzb zzb2, @Nullable String string2, @Nullable int[] nArray) {
        this.zzb = dataType;
        this.zzd = n;
        this.zzc = string;
        this.zze = device;
        this.zzf = zzb2;
        this.zzg = string2;
        this.zzi = this.zzc();
        this.zzh = nArray != null ? nArray : zza;
    }

    private DataSource(Builder builder) {
        this.zzb = builder.zza;
        this.zzd = builder.zzb;
        this.zzc = builder.zzc;
        this.zze = builder.zzd;
        this.zzf = builder.zze;
        this.zzg = builder.zzf;
        this.zzi = this.zzc();
        this.zzh = builder.zzg;
    }

    @Nullable
    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzbgq.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzb;
    }

    public int getType() {
        return this.zzd;
    }

    @Nullable
    public String getName() {
        return this.zzc;
    }

    @Nullable
    public String getAppPackageName() {
        if (this.zzf == null) {
            return null;
        }
        return this.zzf.zza();
    }

    @Hide
    @Nullable
    public final zzb zza() {
        return this.zzf;
    }

    @Nullable
    public Device getDevice() {
        return this.zze;
    }

    @Nullable
    public String getStreamName() {
        return this.zzg;
    }

    public int[] getDataQualityStandards() {
        return this.zzh;
    }

    public String getStreamIdentifier() {
        return this.zzi;
    }

    private final String zzc() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.zzd());
        stringBuilder.append(":").append(this.zzb.getName());
        if (this.zzf != null) {
            stringBuilder.append(":").append(this.zzf.zza());
        }
        if (this.zze != null) {
            stringBuilder.append(":").append(this.zze.zza());
        }
        if (this.zzg != null) {
            stringBuilder.append(":").append(this.zzg);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DataSource)) {
            return false;
        }
        DataSource dataSource = (DataSource)((Object)object);
        return this.zzi.equals(dataSource.zzi);
    }

    public int hashCode() {
        return this.zzi.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.zzd());
        if (this.zzc != null) {
            stringBuilder.append(":").append(this.zzc);
        }
        if (this.zzf != null) {
            stringBuilder.append(":").append((Object)this.zzf);
        }
        if (this.zze != null) {
            stringBuilder.append(":").append((Object)this.zze);
        }
        if (this.zzg != null) {
            stringBuilder.append(":").append(this.zzg);
        }
        stringBuilder.append(":").append((Object)this.zzb);
        return stringBuilder.append("}").toString();
    }

    @Hide
    public final String zzb() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        switch (this.zzd) {
            case 0: {
                string7 = "r";
                break;
            }
            case 1: {
                string7 = "d";
                break;
            }
            case 2: {
                string7 = "c";
                break;
            }
            case 3: {
                string7 = "v";
                break;
            }
            default: {
                string7 = "?";
            }
        }
        String string8 = string7;
        String string9 = this.zzb.zzc();
        if (this.zzf == null) {
            string6 = "";
        } else if (this.zzf.equals((Object)com.google.android.gms.fitness.data.zzb.zza)) {
            string6 = ":gms";
        } else {
            String string10 = String.valueOf(this.zzf.zza());
            string6 = string5 = string10.length() != 0 ? ":".concat(string10) : new String(":");
        }
        if (this.zze != null) {
            string4 = this.zze.getModel();
            string3 = this.zze.getUid();
            string2 = new StringBuilder(2 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(":").append(string4).append(":").append(string3).toString();
        } else {
            string2 = string4 = "";
        }
        if (this.zzg != null) {
            String string11 = String.valueOf(this.zzg);
            string = string11.length() != 0 ? ":".concat(string11) : new String(":");
        } else {
            string = "";
        }
        string3 = string;
        return new StringBuilder(1 + String.valueOf(string8).length() + String.valueOf(string9).length() + String.valueOf(string5).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string8).append(":").append(string9).append(string5).append(string4).append(string3).toString();
    }

    @Hide
    public static String zza(int n) {
        switch (n) {
            case 1: {
                return "blood_pressure_esh2002";
            }
            case 2: {
                return "blood_pressure_esh2010";
            }
            case 3: {
                return "blood_pressure_aami";
            }
            case 4: {
                return "blood_pressure_bhs_a_a";
            }
            case 5: {
                return "blood_pressure_bhs_a_b";
            }
            case 6: {
                return "blood_pressure_bhs_b_a";
            }
            case 7: {
                return "blood_pressure_bhs_b_b";
            }
            case 8: {
                return "blood_glucose_iso151972003";
            }
            case 9: {
                return "blood_glucose_iso151972013";
            }
        }
        return "unknown";
    }

    private final String zzd() {
        switch (this.zzd) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
            case 2: {
                return "cleaned";
            }
            case 3: {
                return "converted";
            }
        }
        return "derived";
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSource dataSource = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)dataSource.getDataType(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)dataSource.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (int)dataSource.getType());
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)dataSource.getDevice(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)dataSource.zzf, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)dataSource.getStreamName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (int[])dataSource.getDataQualityStandards(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataSource(Builder builder, zzj zzj2) {
        this(builder);
    }

    public static final class Builder {
        private DataType zza;
        private int zzb = -1;
        private String zzc;
        private Device zzd;
        private zzb zze;
        private String zzf = "";
        private int[] zzg;

        public Builder() {
        }

        public final Builder setDataType(DataType dataType) {
            this.zza = dataType;
            return this;
        }

        public final Builder setType(int n) {
            this.zzb = n;
            return this;
        }

        public final Builder setName(String string) {
            this.zzc = string;
            return this;
        }

        public final Builder setDevice(Device device) {
            this.zzd = device;
            return this;
        }

        public final Builder setAppPackageName(String string) {
            this.zze = com.google.android.gms.fitness.data.zzb.zza(string);
            return this;
        }

        public final Builder setAppPackageName(Context context) {
            return this.setAppPackageName(context.getPackageName());
        }

        public final Builder setStreamName(String string) {
            zzbq.zzb((string != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzf = string;
            return this;
        }

        public final Builder setDataQualityStandards(int ... nArray) {
            this.zzg = nArray;
            return this;
        }

        public final DataSource build() {
            zzbq.zza((this.zza != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzbq.zza((this.zzb >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this, null);
        }
    }
}

