/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzo;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbwl;
import com.google.android.gms.internal.zzcbx;
import java.util.Arrays;

public final class Device
extends zzbgl {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    public static final int TYPE_HEAD_MOUNTED = 6;
    private final String zza;
    private final String zzb;
    private final String zzc;
    private final int zzd;
    private final int zze;
    @Hide
    public static final Parcelable.Creator<Device> CREATOR = new zzo();

    public static Device getLocalDevice(Context context) {
        int n = zzbwl.zza(context);
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    @Hide
    public Device(String string, String string2, String string3, int n, int n2) {
        this.zza = (String)zzbq.zza((Object)string);
        this.zzb = (String)zzbq.zza((Object)string2);
        String string4 = string3;
        if (string4 == null) {
            throw new IllegalStateException("Device UID is null.");
        }
        this.zzc = string4;
        this.zzd = n;
        this.zze = n2;
    }

    @Deprecated
    @Hide
    private Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(string, string2, string4, n, n2);
    }

    public final String getManufacturer() {
        return this.zza;
    }

    public final String getModel() {
        return this.zzb;
    }

    public final String getUid() {
        return this.zzc;
    }

    public final int getType() {
        return this.zzd;
    }

    @Hide
    final String zza() {
        return String.format("%s:%s:%s", this.zza, this.zzb, this.zzc);
    }

    public final String toString() {
        return String.format("Device{%s:%s:%s}", this.zza(), this.zzd, this.zze);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Device)) {
            return false;
        }
        Device device = (Device)((Object)object);
        return zzbg.zza((Object)this.zza, (Object)device.zza) && zzbg.zza((Object)this.zzb, (Object)device.zzb) && zzbg.zza((Object)this.zzc, (Object)device.zzc) && this.zzd == device.zzd && this.zze == device.zze;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zzd});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Device device = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)device.getManufacturer(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)device.getModel(), (boolean)false);
        Device device2 = device;
        zzbgo.zza((Parcel)parcel2, (int)4, (String)(device2.zze == 1 ? device2.zzc : zzcbx.zza(device2.zzc)), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (int)device.getType());
        zzbgo.zza((Parcel)parcel2, (int)6, (int)device.zze);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

