/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzac;
import com.google.android.gms.fitness.data.zzad;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.internal.zzfmk;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class Session
extends zzbgl {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final long zza;
    private final long zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final int zzf;
    private final zzb zzg;
    @Nullable
    private final Long zzh;
    @Hide
    public static final Parcelable.Creator<Session> CREATOR = new zzad();

    @Hide
    public Session(long l, long l2, String string, String string2, String string3, int n, zzb zzb2, @Nullable Long l3) {
        this.zza = l;
        this.zzb = l2;
        this.zzc = string;
        this.zzd = string2;
        this.zze = string3;
        this.zzf = n;
        this.zzg = zzb2;
        this.zzh = l3;
    }

    private Session(Builder builder) {
        this(builder.zza, builder.zzb, builder.zzc, builder.zzd, builder.zze, builder.zzf, null, builder.zzg);
    }

    @Nullable
    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzbgq.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zza, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzb, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzbq.zza((this.zzh != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzh, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzh != null;
    }

    public boolean isOngoing() {
        return this.zzb == 0L;
    }

    public String getName() {
        return this.zzc;
    }

    @Nullable
    public String getIdentifier() {
        return this.zzd;
    }

    @Nullable
    public String getDescription() {
        return this.zze;
    }

    public String getActivity() {
        return zzfmk.zza(this.zzf);
    }

    public String getAppPackageName() {
        if (this.zzg == null) {
            return null;
        }
        return this.zzg.zza();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Session)) {
            return false;
        }
        Session session = (Session)((Object)object);
        return this.zza == session.zza && this.zzb == session.zzb && zzbg.zza((Object)this.zzc, (Object)session.zzc) && zzbg.zza((Object)this.zzd, (Object)session.zzd) && zzbg.zza((Object)this.zze, (Object)session.zze) && zzbg.zza((Object)((Object)this.zzg), (Object)((Object)session.zzg)) && this.zzf == session.zzf;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzd});
    }

    public String toString() {
        return zzbg.zza((Object)((Object)this)).zza("startTime", (Object)this.zza).zza("endTime", (Object)this.zzb).zza("name", (Object)this.zzc).zza("identifier", (Object)this.zzd).zza("description", (Object)this.zze).zza("activity", (Object)this.zzf).zza("application", (Object)this.zzg).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Session session = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)session.zza);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)session.zzb);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)session.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)session.getIdentifier(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)session.getDescription(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (int)session.zzf);
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)session.zzg, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (Long)session.zzh, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ Session(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private long zza = 0L;
        private long zzb = 0L;
        private String zzc = null;
        private String zzd;
        private String zze;
        private int zzf = 4;
        @Nullable
        private Long zzg;

        public Builder() {
        }

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzbq.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zza = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzbq.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzb = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzbq.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.zzc = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzbq.zzb((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzd = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzbq.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zze = string;
            return this;
        }

        public Builder setActivity(String string) {
            int n = zzfmk.zza(string);
            Builder builder = this;
            this.zzf = n;
            return builder;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzg = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzbq.zza((this.zza > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzbq.zza((this.zzb == 0L || this.zzb > this.zza ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzd == null) {
                String string = this.zzc == null ? "" : this.zzc;
                long l = this.zza;
                this.zzd = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.zze == null) {
                this.zze = "";
            }
            return new Session(this, null);
        }
    }
}

