/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.fitness.request.zzj;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzbzu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends zzbgl {
    private final long zza;
    private final long zzb;
    private final List<DataSource> zzc;
    private final List<DataType> zzd;
    private final List<Session> zze;
    private final boolean zzf;
    private final boolean zzg;
    @Nullable
    private final zzbzt zzh;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzj();

    @Hide
    DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.zza = l;
        this.zzb = l2;
        this.zzc = Collections.unmodifiableList(list);
        this.zzd = Collections.unmodifiableList(list2);
        this.zze = list3;
        this.zzf = bl;
        this.zzg = bl2;
        this.zzh = zzbzu.zza(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zza, builder.zzb, (List<DataSource>)builder.zzc, (List<DataType>)builder.zzd, (List<Session>)builder.zze, builder.zzf, builder.zzg, (zzbzt)null);
    }

    @Hide
    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzbzt zzbzt2) {
        this(dataDeleteRequest.zza, dataDeleteRequest.zzb, dataDeleteRequest.zzc, dataDeleteRequest.zzd, dataDeleteRequest.zze, dataDeleteRequest.zzf, dataDeleteRequest.zzg, zzbzt2);
    }

    @Hide
    private DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, @Nullable zzbzt zzbzt2) {
        this.zza = l;
        this.zzb = l2;
        this.zzc = Collections.unmodifiableList(list);
        this.zzd = Collections.unmodifiableList(list2);
        this.zze = list3;
        this.zzf = bl;
        this.zzg = bl2;
        this.zzh = zzbzt2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zza, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzb, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzc;
    }

    public List<DataType> getDataTypes() {
        return this.zzd;
    }

    public List<Session> getSessions() {
        return this.zze;
    }

    public boolean deleteAllData() {
        return this.zzf;
    }

    public boolean deleteAllSessions() {
        return this.zzg;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataDeleteRequest)) break block3;
                DataDeleteRequest dataDeleteRequest = (DataDeleteRequest)((Object)object);
                DataDeleteRequest dataDeleteRequest2 = this;
                if (!(dataDeleteRequest2.zza == dataDeleteRequest.zza && dataDeleteRequest2.zzb == dataDeleteRequest.zzb && zzbg.zza(dataDeleteRequest2.zzc, dataDeleteRequest.zzc) && zzbg.zza(dataDeleteRequest2.zzd, dataDeleteRequest.zzd) && zzbg.zza(dataDeleteRequest2.zze, dataDeleteRequest.zze) && dataDeleteRequest2.zzf == dataDeleteRequest.zzf && dataDeleteRequest2.zzg == dataDeleteRequest.zzg)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb});
    }

    public String toString() {
        return zzbg.zza((Object)((Object)this)).zza("startTimeMillis", (Object)this.zza).zza("endTimeMillis", (Object)this.zzb).zza("dataSources", this.zzc).zza("dateTypes", this.zzd).zza("sessions", this.zze).zza("deleteAllData", (Object)this.zzf).zza("deleteAllSessions", (Object)this.zzg).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataDeleteRequest dataDeleteRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)dataDeleteRequest.zza);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)dataDeleteRequest.zzb);
        zzbgo.zzc((Parcel)parcel2, (int)3, dataDeleteRequest.getDataSources(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, dataDeleteRequest.getDataTypes(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, dataDeleteRequest.getSessions(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (boolean)dataDeleteRequest.deleteAllData());
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)dataDeleteRequest.deleteAllSessions());
        DataDeleteRequest dataDeleteRequest2 = dataDeleteRequest;
        zzbgo.zza((Parcel)parcel2, (int)8, (IBinder)(dataDeleteRequest2.zzh == null ? null : dataDeleteRequest2.zzh.asBinder()), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataDeleteRequest(Builder builder, zzi zzi2) {
        this(builder);
    }

    public static class Builder {
        private long zza;
        private long zzb;
        private List<DataSource> zzc = new ArrayList<DataSource>();
        private List<DataType> zzd = new ArrayList<DataType>();
        private List<Session> zze = new ArrayList<Session>();
        private boolean zzf = false;
        private boolean zzg = false;

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbq.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zza = timeUnit.toMillis(l);
            this.zzb = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzbq.zzb((boolean)this.zzd.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzbq.zzb((boolean)this.zzc.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzf = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzbq.zzb((!this.zzf ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzbq.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzd.contains((Object)dataType)) {
                this.zzd.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzbq.zzb((!this.zzf ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzbq.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzc.contains((Object)dataSource)) {
                this.zzc.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzbq.zzb((!this.zzg ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzbq.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzbq.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zze.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzbq.zzb((boolean)this.zze.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzg = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzbq.zza((this.zza > 0L && this.zzb > this.zza ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzf || !this.zzc.isEmpty() || !this.zzd.isEmpty();
            boolean bl2 = this.zzg || !this.zze.isEmpty();
            zzbq.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            Builder builder = this;
            if (!builder.zze.isEmpty()) {
                for (Session session : builder.zze) {
                    zzbq.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= builder.zza && session.getEndTime(TimeUnit.MILLISECONDS) <= builder.zzb ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, builder.zza, builder.zzb});
                }
            }
            return new DataDeleteRequest(this, null);
        }
    }
}

