/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.fitness.request.zzz;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzbzu;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class DataUpdateRequest
extends zzbgl {
    private final long zza;
    private final long zzb;
    private final DataSet zzc;
    @Nullable
    private final zzbzt zzd;
    public static final Parcelable.Creator<DataUpdateRequest> CREATOR = new zzz();

    @Hide
    public DataUpdateRequest(long l, long l2, DataSet dataSet, @Nullable IBinder iBinder) {
        this.zza = l;
        this.zzb = l2;
        this.zzc = dataSet;
        this.zzd = zzbzu.zza(iBinder);
    }

    @Hide
    private DataUpdateRequest(Builder builder) {
        this(builder.zza, builder.zzb, builder.zzc, null);
    }

    @Hide
    public DataUpdateRequest(DataUpdateRequest dataUpdateRequest, IBinder iBinder) {
        this(dataUpdateRequest.zza, dataUpdateRequest.zzb, dataUpdateRequest.getDataSet(), iBinder);
    }

    @Hide
    public final long zza() {
        return this.zza;
    }

    @Hide
    public final long zzb() {
        return this.zzb;
    }

    public DataSet getDataSet() {
        return this.zzc;
    }

    public IBinder getCallbackBinder() {
        if (this.zzd == null) {
            return null;
        }
        return this.zzd.asBinder();
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zza, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzb, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof DataUpdateRequest)) break block3;
                DataUpdateRequest dataUpdateRequest = (DataUpdateRequest)((Object)object);
                DataUpdateRequest dataUpdateRequest2 = this;
                if (!(dataUpdateRequest2.zza == dataUpdateRequest.zza && dataUpdateRequest2.zzb == dataUpdateRequest.zzb && zzbg.zza((Object)((Object)dataUpdateRequest2.zzc), (Object)((Object)dataUpdateRequest.zzc)))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc});
    }

    public String toString() {
        return zzbg.zza((Object)((Object)this)).zza("startTimeMillis", (Object)this.zza).zza("endTimeMillis", (Object)this.zzb).zza("dataSet", (Object)this.zzc).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataUpdateRequest dataUpdateRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)dataUpdateRequest.zza);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)dataUpdateRequest.zzb);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)dataUpdateRequest.getDataSet(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (IBinder)dataUpdateRequest.getCallbackBinder(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ DataUpdateRequest(Builder builder, zzy zzy2) {
        this(builder);
    }

    public static class Builder {
        private long zza;
        private long zzb;
        private DataSet zzc;

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzbq.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzbq.zzb((l2 >= l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zza = timeUnit.toMillis(l);
            this.zzb = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setDataSet(DataSet dataSet) {
            zzbq.zza((Object)((Object)dataSet), (Object)"Must set the data set");
            this.zzc = dataSet;
            return this;
        }

        public DataUpdateRequest build() {
            Builder builder = this;
            zzbq.zza((long)builder.zza, (Object)"Must set a non-zero value for startTimeMillis/startTime");
            zzbq.zza((long)builder.zzb, (Object)"Must set a non-zero value for endTimeMillis/endTime");
            zzbq.zza((Object)((Object)builder.zzc), (Object)"Must set the data set");
            for (DataPoint dataPoint : builder.zzc.getDataPoints()) {
                long l;
                long l2 = dataPoint.getStartTime(TimeUnit.MILLISECONDS);
                zzbq.zza((!(l2 > (l = dataPoint.getEndTime(TimeUnit.MILLISECONDS)) || l2 != 0L && l2 < builder.zza || l2 != 0L && l2 > builder.zzb || l > builder.zzb || l < builder.zza) ? 1 : 0) != 0, (String)"Data Point's startTimeMillis %d, endTimeMillis %d should lie between timeRange provided in the request. StartTimeMillis %d, EndTimeMillis: %d", (Object[])new Object[]{l2, l, builder.zza, builder.zzb});
            }
            return new DataUpdateRequest(this, null);
        }
    }
}

