/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzac;
import com.google.android.gms.fitness.request.zzad;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbwi;
import com.google.android.gms.internal.zzbyt;
import com.google.android.gms.internal.zzbyu;
import com.google.android.gms.internal.zzfmk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoalsReadRequest
extends zzbgl {
    private final zzbyt zza;
    private final List<DataType> zzb;
    private final List<Integer> zzc;
    private final List<Integer> zzd;
    public static final Parcelable.Creator<GoalsReadRequest> CREATOR = new zzad();

    public List<DataType> getDataTypes() {
        return this.zzb;
    }

    @Nullable
    public List<Integer> getObjectiveTypes() {
        if (this.zzc.isEmpty()) {
            return null;
        }
        return this.zzc;
    }

    @Nullable
    public List<String> getActivityNames() {
        if (this.zzd.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : this.zzd) {
            arrayList.add(zzfmk.zza(n));
        }
        return arrayList;
    }

    @Hide
    GoalsReadRequest(IBinder iBinder, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this.zza = iBinder == null ? null : zzbyu.zza(iBinder);
        this.zzb = list;
        this.zzc = list2;
        this.zzd = list3;
    }

    private GoalsReadRequest(Builder builder) {
        this((zzbyt)null, (List<DataType>)builder.zza, (List<Integer>)builder.zzb, (List<Integer>)builder.zzc);
    }

    @Hide
    public GoalsReadRequest(GoalsReadRequest goalsReadRequest, zzbyt zzbyt2) {
        this(zzbyt2, goalsReadRequest.getDataTypes(), goalsReadRequest.zzc, goalsReadRequest.zzd);
    }

    private GoalsReadRequest(zzbyt zzbyt2, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this(zzbyt2 == null ? null : zzbyt2.asBinder(), list, list2, list3);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GoalsReadRequest)) break block3;
                GoalsReadRequest goalsReadRequest = (GoalsReadRequest)((Object)object);
                GoalsReadRequest goalsReadRequest2 = this;
                if (!(zzbg.zza(goalsReadRequest2.zzb, goalsReadRequest.zzb) && zzbg.zza(goalsReadRequest2.zzc, goalsReadRequest.zzc) && zzbg.zza(goalsReadRequest2.zzd, goalsReadRequest.zzd))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzb, this.zzc, this.getActivityNames()});
    }

    public String toString() {
        return zzbg.zza((Object)((Object)this)).zza("dataTypes", this.zzb).zza("objectiveTypes", this.zzc).zza("activities", this.getActivityNames()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoalsReadRequest goalsReadRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (IBinder)goalsReadRequest.zza.asBinder(), (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)2, goalsReadRequest.getDataTypes(), (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)3, goalsReadRequest.zzc, (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)4, goalsReadRequest.zzd, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ GoalsReadRequest(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private final List<DataType> zza = new ArrayList<DataType>();
        private final List<Integer> zzb = new ArrayList<Integer>();
        private final List<Integer> zzc = new ArrayList<Integer>();

        public Builder() {
        }

        public Builder addDataType(DataType dataType) {
            zzbq.zza((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zza.contains((Object)dataType)) {
                this.zza.add(dataType);
            }
            return this;
        }

        public Builder addActivity(String string) {
            int n = zzfmk.zza(string);
            zzbq.zza((n != 4 ? 1 : 0) != 0, (Object)"Attempting to add an unknown activity");
            zzbwi.zza(n, this.zzc);
            return this;
        }

        public Builder addObjectiveType(int n) {
            zzbq.zza((n == 1 || n == 2 || n == 3 ? 1 : 0) != 0, (Object)"Attempting to add an invalid objective type");
            if (!this.zzb.contains(n)) {
                this.zzb.add(n);
            }
            return this;
        }

        public GoalsReadRequest build() {
            zzbq.zza((!this.zza.isEmpty() ? 1 : 0) != 0, (Object)"At least one data type should be specified.");
            return new GoalsReadRequest(this, null);
        }
    }
}

