/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzat;
import com.google.android.gms.fitness.request.zzau;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbwh;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzbzu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends zzbgl {
    private final Session zza;
    private final List<DataSet> zzb;
    private final List<DataPoint> zzc;
    @Nullable
    private final zzbzt zzd;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzau();

    @Hide
    SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.zza = session;
        this.zzb = Collections.unmodifiableList(list);
        this.zzc = Collections.unmodifiableList(list2);
        this.zzd = zzbzu.zza(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zza, (List<DataSet>)builder.zzb, (List<DataPoint>)builder.zzc, (zzbzt)null);
    }

    @Hide
    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzbzt zzbzt2) {
        this(sessionInsertRequest.zza, sessionInsertRequest.zzb, sessionInsertRequest.zzc, zzbzt2);
    }

    @Hide
    private SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, @Nullable zzbzt zzbzt2) {
        this.zza = session;
        this.zzb = Collections.unmodifiableList(list);
        this.zzc = Collections.unmodifiableList(list2);
        this.zzd = zzbzt2;
    }

    public Session getSession() {
        return this.zza;
    }

    public List<DataSet> getDataSets() {
        return this.zzb;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzc;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof SessionInsertRequest)) break block3;
                SessionInsertRequest sessionInsertRequest = (SessionInsertRequest)((Object)object);
                SessionInsertRequest sessionInsertRequest2 = this;
                if (!(zzbg.zza((Object)((Object)sessionInsertRequest2.zza), (Object)((Object)sessionInsertRequest.zza)) && zzbg.zza(sessionInsertRequest2.zzb, sessionInsertRequest.zzb) && zzbg.zza(sessionInsertRequest2.zzc, sessionInsertRequest.zzc))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc});
    }

    public String toString() {
        return zzbg.zza((Object)((Object)this)).zza("session", (Object)this.zza).zza("dataSets", this.zzb).zza("aggregateDataPoints", this.zzc).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionInsertRequest sessionInsertRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)sessionInsertRequest.getSession(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, sessionInsertRequest.getDataSets(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, sessionInsertRequest.getAggregateDataPoints(), (boolean)false);
        SessionInsertRequest sessionInsertRequest2 = sessionInsertRequest;
        zzbgo.zza((Parcel)parcel2, (int)4, (IBinder)(sessionInsertRequest2.zzd == null ? null : sessionInsertRequest2.zzd.asBinder()), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionInsertRequest(Builder builder, zzat zzat2) {
        this(builder);
    }

    public static class Builder {
        private Session zza;
        private List<DataSet> zzb = new ArrayList<DataSet>();
        private List<DataPoint> zzc = new ArrayList<DataPoint>();
        private List<DataSource> zzd = new ArrayList<DataSource>();

        public Builder() {
        }

        public Builder setSession(Session session) {
            this.zza = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzbq.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzbq.zza((!this.zzd.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            zzbq.zzb((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzd.add(dataSource);
            this.zzb.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzbq.zzb((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzbq.zza((!this.zzd.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            DataSet.zza(dataPoint);
            this.zzd.add(dataSource);
            this.zzc.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzbq.zza((this.zza != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzbq.zza((this.zza.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            Builder builder = this;
            Iterator<zzbgl> iterator = builder.zzb.iterator();
            while (iterator.hasNext()) {
                for (DataPoint dataPoint : iterator.next().getDataPoints()) {
                    builder.zza(dataPoint);
                }
            }
            for (DataPoint dataPoint : builder.zzc) {
                builder.zza(dataPoint);
            }
            return new SessionInsertRequest(this, null);
        }

        private final void zza(DataPoint dataPoint) {
            DataPoint dataPoint2 = dataPoint;
            Builder builder = this;
            long l = builder.zza.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = builder.zza.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint2.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzbwh.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbq.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (dataPoint2.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint2.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
            dataPoint2 = dataPoint;
            builder = this;
            l = builder.zza.getStartTime(TimeUnit.NANOSECONDS);
            l2 = builder.zza.getEndTime(TimeUnit.NANOSECONDS);
            l3 = dataPoint2.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint2.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzbwh.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbq.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (l4 != dataPoint2.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint2.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }
    }
}

