/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzav;
import com.google.android.gms.fitness.request.zzaw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbzn;
import com.google.android.gms.internal.zzbzo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
extends zzbgl {
    private final String zza;
    private final String zzb;
    private final long zzc;
    private final long zzd;
    private final List<DataType> zze;
    private final List<DataSource> zzf;
    private boolean zzg;
    private final boolean zzh;
    private final List<String> zzi;
    @Nullable
    private final zzbzn zzj;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzaw();

    @Hide
    SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, IBinder iBinder) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = l;
        this.zzd = l2;
        this.zze = list;
        this.zzf = list2;
        this.zzg = bl;
        this.zzh = bl2;
        this.zzi = list3;
        this.zzj = zzbzo.zza(iBinder);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zza, builder.zzb, builder.zzc, builder.zzd, (List<DataType>)builder.zze, (List<DataSource>)builder.zzf, builder.zzg, builder.zzh, (List<String>)builder.zzi, (zzbzn)null);
    }

    @Hide
    public SessionReadRequest(SessionReadRequest sessionReadRequest, zzbzn zzbzn2) {
        this(sessionReadRequest.zza, sessionReadRequest.zzb, sessionReadRequest.zzc, sessionReadRequest.zzd, sessionReadRequest.zze, sessionReadRequest.zzf, sessionReadRequest.zzg, sessionReadRequest.zzh, sessionReadRequest.zzi, zzbzn2);
    }

    @Hide
    private SessionReadRequest(String string, String string2, long l, long l2, List<DataType> list, List<DataSource> list2, boolean bl, boolean bl2, List<String> list3, @Nullable zzbzn zzbzn2) {
        this(string, string2, l, l2, list, list2, bl, bl2, list3, zzbzn2 == null ? null : zzbzn2.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzc, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzd, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public String getSessionName() {
        return this.zza;
    }

    @Nullable
    public String getSessionId() {
        return this.zzb;
    }

    public List<DataType> getDataTypes() {
        return this.zze;
    }

    public List<DataSource> getDataSources() {
        return this.zzf;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzg;
    }

    public List<String> getExcludedPackages() {
        return this.zzi;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadRequest)) break block3;
                SessionReadRequest sessionReadRequest = (SessionReadRequest)((Object)object);
                SessionReadRequest sessionReadRequest2 = this;
                if (!(zzbg.zza((Object)sessionReadRequest2.zza, (Object)sessionReadRequest.zza) && sessionReadRequest2.zzb.equals(sessionReadRequest.zzb) && sessionReadRequest2.zzc == sessionReadRequest.zzc && sessionReadRequest2.zzd == sessionReadRequest.zzd && zzbg.zza(sessionReadRequest2.zze, sessionReadRequest.zze) && zzbg.zza(sessionReadRequest2.zzf, sessionReadRequest.zzf) && sessionReadRequest2.zzg == sessionReadRequest.zzg && sessionReadRequest2.zzi.equals(sessionReadRequest.zzi) && sessionReadRequest2.zzh == sessionReadRequest.zzh)) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zzd});
    }

    public String toString() {
        return zzbg.zza((Object)((Object)this)).zza("sessionName", (Object)this.zza).zza("sessionId", (Object)this.zzb).zza("startTimeMillis", (Object)this.zzc).zza("endTimeMillis", (Object)this.zzd).zza("dataTypes", this.zze).zza("dataSources", this.zzf).zza("sessionsFromAllApps", (Object)this.zzg).zza("excludedPackages", this.zzi).zza("useServer", (Object)this.zzh).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadRequest sessionReadRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)sessionReadRequest.getSessionName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)sessionReadRequest.getSessionId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)sessionReadRequest.zzc);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)sessionReadRequest.zzd);
        zzbgo.zzc((Parcel)parcel2, (int)5, sessionReadRequest.getDataTypes(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, sessionReadRequest.getDataSources(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)sessionReadRequest.includeSessionsFromAllApps());
        zzbgo.zza((Parcel)parcel2, (int)8, (boolean)sessionReadRequest.zzh);
        zzbgo.zzb((Parcel)parcel2, (int)9, sessionReadRequest.getExcludedPackages(), (boolean)false);
        SessionReadRequest sessionReadRequest2 = sessionReadRequest;
        zzbgo.zza((Parcel)parcel2, (int)10, (IBinder)(sessionReadRequest2.zzj == null ? null : sessionReadRequest2.zzj.asBinder()), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionReadRequest(Builder builder, zzav zzav2) {
        this(builder);
    }

    public static class Builder {
        private String zza;
        private String zzb;
        private long zzc = 0L;
        private long zzd = 0L;
        private List<DataType> zze = new ArrayList<DataType>();
        private List<DataSource> zzf = new ArrayList<DataSource>();
        private boolean zzg = false;
        private boolean zzh = false;
        private List<String> zzi = new ArrayList<String>();

        public Builder() {
        }

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzc = timeUnit.toMillis(l);
            this.zzd = timeUnit.toMillis(l2);
            return this;
        }

        public Builder setSessionName(String string) {
            this.zza = string;
            return this;
        }

        public Builder setSessionId(String string) {
            this.zzb = string;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzbq.zza((Object)((Object)dataSource), (Object)"Attempting to add a null data source");
            if (!this.zzf.contains((Object)dataSource)) {
                this.zzf.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzbq.zza((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zze.contains((Object)dataType)) {
                this.zze.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzg = true;
            return this;
        }

        public Builder excludePackage(String string) {
            zzbq.zza((Object)string, (Object)"Attempting to use a null package name");
            if (!this.zzi.contains(string)) {
                this.zzi.add(string);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzh = true;
            return this;
        }

        public SessionReadRequest build() {
            zzbq.zzb((this.zzc > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzc});
            zzbq.zzb((this.zzd > 0L && this.zzd > this.zzc ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzd});
            return new SessionReadRequest(this, null);
        }
    }
}

