/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.fitness.BleApi;
import com.google.android.gms.fitness.FitnessOptions;
import com.google.android.gms.fitness.data.BleDevice;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.zza;
import com.google.android.gms.fitness.zzb;
import com.google.android.gms.fitness.zzc;
import com.google.android.gms.internal.zzbws;
import com.google.android.gms.internal.zzbzw;
import com.google.android.gms.internal.zzcbt;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.List;

public class BleClient
extends GoogleApi<FitnessOptions> {
    private static final BleApi zzhhb = zzs.zzanu() ? new zzbzw() : new zzcbt();

    BleClient(@NonNull Context context, @NonNull FitnessOptions fitnessOptions) {
        super(context, zzbws.zzhmg, (Api.ApiOptions)fitnessOptions, GoogleApi.zza.zzfsr);
    }

    BleClient(@NonNull Activity activity, @NonNull FitnessOptions fitnessOptions) {
        super(activity, zzbws.zzhmg, (Api.ApiOptions)fitnessOptions, GoogleApi.zza.zzfsr);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public Task<Void> startBleScan(List<DataType> list, int n, BleScanCallback bleScanCallback) {
        if (!zzs.zzanu()) {
            return Tasks.forException((Exception)new ApiException(zzcbt.zzhnn));
        }
        zzci zzci2 = this.zza(bleScanCallback, BleScanCallback.class.getSimpleName());
        zzb zzb2 = new zzb(this, zzci2, zzci2, list, n);
        zzc zzc2 = new zzc(this, zzci2.zzakx(), zzci2);
        return this.zza(zzb2, zzc2);
    }

    public Task<Boolean> stopBleScan(BleScanCallback bleScanCallback) {
        if (!zzs.zzanu()) {
            return Tasks.forException((Exception)new ApiException(zzcbt.zzhnn));
        }
        return this.zza(zzcm.zzb((Object)bleScanCallback, (String)BleScanCallback.class.getSimpleName()));
    }

    public Task<Void> claimBleDevice(BleDevice bleDevice) {
        return zzbj.zzb(zzhhb.claimBleDevice(this.zzahw(), bleDevice));
    }

    public Task<Void> claimBleDevice(String string) {
        return zzbj.zzb(zzhhb.claimBleDevice(this.zzahw(), string));
    }

    public Task<Void> unclaimBleDevice(String string) {
        return zzbj.zzb(zzhhb.unclaimBleDevice(this.zzahw(), string));
    }

    public Task<Void> unclaimBleDevice(BleDevice bleDevice) {
        return zzbj.zzb(zzhhb.unclaimBleDevice(this.zzahw(), bleDevice));
    }

    public Task<List<BleDevice>> listClaimedBleDevices() {
        return zzbj.zza(zzhhb.listClaimedBleDevices(this.zzahw()), (zzbo)zza.zzgui);
    }
}

