/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerRegistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzbgp;
import com.google.android.gms.internal.zzbgq;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<DailyTotalResult> readDailyTotalFromLocalDevice(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public PendingResult<Status> updateData(GoogleApiClient var1, DataUpdateRequest var2);

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<Status> registerDataUpdateListener(GoogleApiClient var1, DataUpdateListenerRegistrationRequest var2);

    public PendingResult<Status> unregisterDataUpdateListener(GoogleApiClient var1, PendingIntent var2);

    public static class ViewIntentBuilder {
        private final Context zzaiq;
        private final DataType zzhhj;
        private DataSource zzhhk;
        private long zzhhl;
        private long zzhhm;
        private String zzhhn;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.zzaiq = context;
            this.zzhhj = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            this.zzhhl = timeUnit.toMillis(l);
            this.zzhhm = timeUnit.toMillis(l2);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzbq.zzb((boolean)dataSource.getDataType().equals((Object)this.zzhhj), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzhhj});
            this.zzhhk = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String string) {
            this.zzhhn = string;
            return this;
        }

        public Intent build() {
            zzbq.zza((this.zzhhl > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzbq.zza((this.zzhhm > this.zzhhl ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzhhk.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzhhl);
            intent.putExtra("vnd.google.fitness.end_time", this.zzhhm);
            zzbgq.zza((zzbgp)this.zzhhk, (Intent)intent, (String)"vnd.google.fitness.data_source");
            Intent intent2 = intent;
            ViewIntentBuilder viewIntentBuilder = this;
            if (viewIntentBuilder.zzhhn != null) {
                Intent intent3 = new Intent(intent2).setPackage(viewIntentBuilder.zzhhn);
                ResolveInfo resolveInfo = viewIntentBuilder.zzaiq.getPackageManager().resolveActivity(intent3, 0);
                if (resolveInfo != null) {
                    String string = resolveInfo.activityInfo.name;
                    intent3.setComponent(new ComponentName(viewIntentBuilder.zzhhn, string));
                    return intent3;
                }
            }
            return intent2;
        }
    }
}

