/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Response;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.fitness.FitnessOptions;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateListenerRegistrationRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DataReadResponse;
import com.google.android.gms.fitness.zzi;
import com.google.android.gms.fitness.zzj;
import com.google.android.gms.internal.zzbxj;
import com.google.android.gms.internal.zzcam;
import com.google.android.gms.tasks.Task;

public class HistoryClient
extends GoogleApi<FitnessOptions> {
    private static final HistoryApi zzhho = new zzcam();

    HistoryClient(@NonNull Context context, @NonNull FitnessOptions fitnessOptions) {
        super(context, zzbxj.zzhmg, (Api.ApiOptions)fitnessOptions, GoogleApi.zza.zzfsr);
    }

    HistoryClient(@NonNull Activity activity, @NonNull FitnessOptions fitnessOptions) {
        super(activity, zzbxj.zzhmg, (Api.ApiOptions)fitnessOptions, GoogleApi.zza.zzfsr);
    }

    public Task<DataReadResponse> readData(DataReadRequest dataReadRequest) {
        return zzbj.zza(zzhho.readData(this.zzahw(), dataReadRequest), (Response)new DataReadResponse());
    }

    public Task<DataSet> readDailyTotal(DataType dataType) {
        return zzbj.zza(zzhho.readDailyTotal(this.zzahw(), dataType), (zzbo)zzi.zzgui);
    }

    public Task<DataSet> readDailyTotalFromLocalDevice(DataType dataType) {
        return zzbj.zza(zzhho.readDailyTotalFromLocalDevice(this.zzahw(), dataType), (zzbo)zzj.zzgui);
    }

    public Task<Void> insertData(DataSet dataSet) {
        return zzbj.zzb(zzhho.insertData(this.zzahw(), dataSet));
    }

    public Task<Void> deleteData(DataDeleteRequest dataDeleteRequest) {
        return zzbj.zzb(zzhho.deleteData(this.zzahw(), dataDeleteRequest));
    }

    public Task<Void> updateData(DataUpdateRequest dataUpdateRequest) {
        return zzbj.zzb(zzhho.updateData(this.zzahw(), dataUpdateRequest));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public Task<Void> registerDataUpdateListener(DataUpdateListenerRegistrationRequest dataUpdateListenerRegistrationRequest) {
        return zzbj.zzb(zzhho.registerDataUpdateListener(this.zzahw(), dataUpdateListenerRegistrationRequest));
    }

    public Task<Void> unregisterDataUpdateListener(PendingIntent pendingIntent) {
        return zzbj.zzb(zzhho.unregisterDataUpdateListener(this.zzahw(), pendingIntent));
    }
}

