/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzfmk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends zzbgl
implements ReflectedParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final long zzhhl;
    private final long zzhhm;
    private final Session zzhhs;
    private final int zzhia;
    private final List<DataSet> zzhib;
    private final int zzhic;
    private boolean zzhid = false;
    @Hide
    public static final Parcelable.Creator<Bucket> CREATOR = new zze();

    @Hide
    Bucket(long l, long l2, Session session, int n, List<DataSet> list, int n2, boolean bl) {
        this.zzhhl = l;
        this.zzhhm = l2;
        this.zzhhs = session;
        this.zzhia = n;
        this.zzhib = list;
        this.zzhic = n2;
        this.zzhid = bl;
    }

    @Hide
    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(rawBucket.zzhhl, rawBucket.zzhhm, rawBucket.zzhhs, rawBucket.zzhlk, Bucket.zza(rawBucket.zzhib, list), rawBucket.zzhic, rawBucket.zzhid);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhm, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzhhs;
    }

    public String getActivity() {
        return zzfmk.getName(this.zzhia);
    }

    @Hide
    public final int getActivityType() {
        return this.zzhia;
    }

    public List<DataSet> getDataSets() {
        return this.zzhib;
    }

    @Nullable
    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzhib) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzhic;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bucket)) {
            return false;
        }
        Bucket bucket = (Bucket)((Object)object);
        return this.zzhhl == bucket.zzhhl && this.zzhhm == bucket.zzhhm && this.zzhia == bucket.zzhia && zzbg.equal(this.zzhib, bucket.zzhib) && this.zzhic == bucket.zzhic && this.zzhid == bucket.zzhid;
    }

    @Hide
    public final boolean zza(Bucket bucket) {
        return this.zzhhl == bucket.zzhhl && this.zzhhm == bucket.zzhhm && this.zzhia == bucket.zzhia && this.zzhic == bucket.zzhic;
    }

    @Hide
    public final boolean zzarm() {
        if (this.zzhid) {
            return true;
        }
        Iterator<DataSet> iterator = this.zzhib.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzarm()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhl, this.zzhhm, this.zzhia, this.zzhic});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("startTime", (Object)this.zzhhl).zzg("endTime", (Object)this.zzhhm).zzg("activity", (Object)this.zzhia).zzg("dataSets", this.zzhib).zzg("bucketType", (Object)Bucket.zzda(this.zzhic)).zzg("serverHasMoreData", (Object)this.zzhid).toString();
    }

    @Hide
    public static String zzda(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Bucket bucket = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)bucket.zzhhl);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)bucket.zzhhm);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)bucket.getSession(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)bucket.zzhia);
        zzbgo.zzc((Parcel)parcel2, (int)5, bucket.getDataSets(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, (int)bucket.getBucketType());
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)bucket.zzarm());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

