/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zzf;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbwm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends zzbgl
implements ReflectedParcelable {
    private final int versionCode;
    private final DataSource zzhhk;
    private final List<DataPoint> zzhim;
    private final List<DataSource> zzhin;
    private boolean zzhid = false;
    @Hide
    public static final Parcelable.Creator<DataSet> CREATOR = new zzi();

    @Hide
    DataSet(int n, DataSource dataSource, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.versionCode = n;
        this.zzhhk = dataSource;
        this.zzhid = bl;
        this.zzhim = new ArrayList<DataPoint>(list.size());
        this.zzhin = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.zzhim.add(new DataPoint(this.zzhin, rawDataPoint));
        }
    }

    @Hide
    private DataSet(DataSource dataSource) {
        this.versionCode = 3;
        this.zzhhk = (DataSource)((Object)zzbq.checkNotNull((Object)((Object)dataSource)));
        this.zzhim = new ArrayList<DataPoint>();
        this.zzhin = new ArrayList<DataSource>();
        this.zzhin.add(this.zzhhk);
    }

    @Hide
    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.versionCode = 3;
        this.zzhhk = list.get(rawDataSet.zzhll);
        this.zzhin = list;
        this.zzhid = rawDataSet.zzhid;
        List<RawDataPoint> list2 = rawDataSet.zzhln;
        this.zzhim = new ArrayList<DataPoint>(list2.size());
        for (RawDataPoint rawDataPoint : list2) {
            this.zzhim.add(new DataPoint(this.zzhin, rawDataPoint));
        }
    }

    public static DataSet create(DataSource dataSource) {
        zzbq.checkNotNull((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public final DataPoint createDataPoint() {
        return DataPoint.create(this.zzhhk);
    }

    public final void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzbq.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzhhk.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzhhk});
        dataPoint.zzars();
        DataSet.zzb(dataPoint);
        this.zza(dataPoint);
    }

    @Hide
    private final void zza(DataPoint dataPoint) {
        this.zzhim.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzhin.contains((Object)dataSource)) {
            this.zzhin.add(dataSource);
        }
    }

    public final void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    @Hide
    public final void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zza(dataPoint);
        }
    }

    public final DataSource getDataSource() {
        return this.zzhhk;
    }

    public final DataType getDataType() {
        return this.zzhhk.getDataType();
    }

    public final List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzhim);
    }

    public final boolean isEmpty() {
        return this.zzhim.isEmpty();
    }

    @Hide
    public final boolean zzarm() {
        return this.zzhid;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DataSet)) {
            return false;
        }
        DataSet dataSet = (DataSet)((Object)object);
        return zzbg.equal((Object)((Object)this.zzhhk), (Object)((Object)dataSet.zzhhk)) && zzbg.equal(this.zzhim, dataSet.zzhim) && this.zzhid == dataSet.zzhid;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhk});
    }

    public final String toString() {
        List<RawDataPoint> list = this.zzart();
        return String.format("DataSet{%s %s}", this.zzhhk.toDebugString(), this.zzhim.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzhim.size(), list.subList(0, 5)));
    }

    @Hide
    public static void zzb(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzbwm.zza(dataPoint, zzf.zzhie);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    @Hide
    private List<RawDataPoint> zzart() {
        return this.zzac(this.zzhin);
    }

    @Hide
    final List<RawDataPoint> zzac(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzhim.size());
        for (DataPoint dataPoint : this.zzhim) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataSet dataSet = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)dataSet.getDataSource(), (int)n, (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)3, dataSet.zzart(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, dataSet.zzhin, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (boolean)dataSet.zzhid);
        zzbgo.zzc((Parcel)parcel2, (int)1000, (int)dataSet.versionCode);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

