/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzo;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbwl;
import com.google.android.gms.internal.zzcbx;
import java.util.Arrays;

public final class Device
extends zzbgl {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    public static final int TYPE_HEAD_MOUNTED = 6;
    private final String zzhju;
    private final String zzbeg;
    private final String zzhjv;
    private final int type;
    private final int zzhjw;
    @Hide
    public static final Parcelable.Creator<Device> CREATOR = new zzo();

    public static Device getLocalDevice(Context context) {
        int n = zzbwl.zzdi(context);
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    public Device(String string, String string2, String string3, int n) {
        this(string, string2, "", string3, n, 0);
    }

    @Hide
    public Device(String string, String string2, String string3, int n, int n2) {
        this.zzhju = (String)zzbq.checkNotNull((Object)string);
        this.zzbeg = (String)zzbq.checkNotNull((Object)string2);
        String string4 = string3;
        if (string4 == null) {
            throw new IllegalStateException("Device UID is null.");
        }
        this.zzhjv = string4;
        this.type = n;
        this.zzhjw = n2;
    }

    @Deprecated
    @Hide
    private Device(String string, String string2, String string3, String string4, int n, int n2) {
        this(string, string2, string4, n, n2);
    }

    public final String getManufacturer() {
        return this.zzhju;
    }

    public final String getModel() {
        return this.zzbeg;
    }

    public final String getUid() {
        return this.zzhjv;
    }

    public final int getType() {
        return this.type;
    }

    @Hide
    final String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzhju, this.zzbeg, this.zzhjv);
    }

    public final String toString() {
        return String.format("Device{%s:%s:%s}", this.getStreamIdentifier(), this.type, this.zzhjw);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Device)) {
            return false;
        }
        Device device = (Device)((Object)object);
        return zzbg.equal((Object)this.zzhju, (Object)device.zzhju) && zzbg.equal((Object)this.zzbeg, (Object)device.zzbeg) && zzbg.equal((Object)this.zzhjv, (Object)device.zzhjv) && this.type == device.type && this.zzhjw == device.zzhjw;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhju, this.zzbeg, this.zzhjv, this.type});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Device device = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)device.getManufacturer(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)device.getModel(), (boolean)false);
        Device device2 = device;
        zzbgo.zza((Parcel)parcel2, (int)4, (String)(device2.zzhjw == 1 ? device2.zzhjv : zzcbx.zzhw(device2.zzhjv)), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)device.getType());
        zzbgo.zzc((Parcel)parcel2, (int)6, (int)device.zzhjw);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

