/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzab;
import com.google.android.gms.fitness.data.zzp;
import com.google.android.gms.fitness.data.zzr;
import com.google.android.gms.fitness.data.zzs;
import com.google.android.gms.fitness.data.zzx;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzfmk;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Goal
extends zzbgl {
    public static final int OBJECTIVE_TYPE_METRIC = 1;
    public static final int OBJECTIVE_TYPE_DURATION = 2;
    public static final int OBJECTIVE_TYPE_FREQUENCY = 3;
    private final long zzhky;
    private final long zzhkz;
    private final List<Integer> zzhla;
    private final Recurrence zzhlb;
    private final int zzhlc;
    private final MetricObjective zzhld;
    private final DurationObjective zzhle;
    private final FrequencyObjective zzhlf;
    public static final Parcelable.Creator<Goal> CREATOR = new zzs();

    public long getCreateTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhky, TimeUnit.NANOSECONDS);
    }

    public long getStartTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzhlb != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzhlb.zzhlj) {
                case 1: {
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzhlb.zzhlj;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzhky, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(Calendar calendar, TimeUnit timeUnit) {
        if (this.zzhlb != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            switch (this.zzhlb.zzhlj) {
                case 1: {
                    calendar2.add(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 2: {
                    calendar2.add(4, 1);
                    calendar2.set(7, 2);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
                case 3: {
                    calendar2.add(2, 1);
                    calendar2.set(5, 1);
                    calendar2.set(11, 0);
                    return timeUnit.convert(calendar2.getTimeInMillis(), TimeUnit.MILLISECONDS);
                }
            }
            int n = this.zzhlb.zzhlj;
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid unit ").append(n).toString());
        }
        return timeUnit.convert(this.zzhkz, TimeUnit.NANOSECONDS);
    }

    @Nullable
    public String getActivityName() {
        if (this.zzhla.isEmpty() || this.zzhla.size() > 1) {
            return null;
        }
        return zzfmk.getName(this.zzhla.get(0));
    }

    @Nullable
    public Recurrence getRecurrence() {
        return this.zzhlb;
    }

    public int getObjectiveType() {
        return this.zzhlc;
    }

    private static String zzde(int n) {
        switch (n) {
            case 1: {
                return "metric";
            }
            case 2: {
                return "duration";
            }
            case 3: {
                return "frequency";
            }
            case 0: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException("invalid objective type value");
    }

    public MetricObjective getMetricObjective() {
        this.zzdf(1);
        return this.zzhld;
    }

    public DurationObjective getDurationObjective() {
        this.zzdf(2);
        return this.zzhle;
    }

    public FrequencyObjective getFrequencyObjective() {
        this.zzdf(3);
        return this.zzhlf;
    }

    @Hide
    Goal(long l, long l2, List<Integer> list, Recurrence recurrence, int n, MetricObjective metricObjective, DurationObjective durationObjective, FrequencyObjective frequencyObjective) {
        this.zzhky = l;
        this.zzhkz = l2;
        this.zzhla = list;
        this.zzhlb = recurrence;
        this.zzhlc = n;
        this.zzhld = metricObjective;
        this.zzhle = durationObjective;
        this.zzhlf = frequencyObjective;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Goal)) {
            return false;
        }
        Goal goal = (Goal)((Object)object);
        return this.zzhky == goal.zzhky && this.zzhkz == goal.zzhkz && zzbg.equal(this.zzhla, goal.zzhla) && zzbg.equal((Object)((Object)this.zzhlb), (Object)((Object)goal.zzhlb)) && this.zzhlc == goal.zzhlc && zzbg.equal((Object)((Object)this.zzhld), (Object)((Object)goal.zzhld)) && zzbg.equal((Object)((Object)this.zzhle), (Object)((Object)goal.zzhle)) && zzbg.equal((Object)((Object)this.zzhlf), (Object)((Object)goal.zzhlf));
    }

    public int hashCode() {
        return this.zzhlc;
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("activity", (Object)this.getActivityName()).zzg("recurrence", (Object)this.zzhlb).zzg("metricObjective", (Object)this.zzhld).zzg("durationObjective", (Object)this.zzhle).zzg("frequencyObjective", (Object)this.zzhlf).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Goal goal = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)goal.zzhky);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)goal.zzhkz);
        zzbgo.zzd((Parcel)parcel2, (int)3, goal.zzhla, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)goal.getRecurrence(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)goal.getObjectiveType());
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)goal.zzhld, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)goal.zzhle, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)goal.zzhlf, (int)n, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    private final void zzdf(int n) throws MismatchedGoalException {
        if (n != this.zzhlc) {
            throw new MismatchedGoalException(String.format("%s goal does not have %s objective", Goal.zzde(this.zzhlc), Goal.zzde(n)));
        }
    }

    public static class MismatchedGoalException
    extends IllegalStateException {
        public MismatchedGoalException(String string) {
            super(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ObjectiveType {
    }

    public static class FrequencyObjective
    extends zzbgl {
        private final int frequency;
        public static final Parcelable.Creator<FrequencyObjective> CREATOR = new zzr();

        public int getFrequency() {
            return this.frequency;
        }

        public FrequencyObjective(int n) {
            this.frequency = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof FrequencyObjective)) {
                return false;
            }
            FrequencyObjective frequencyObjective = (FrequencyObjective)((Object)object);
            return this.frequency == frequencyObjective.frequency;
        }

        public int hashCode() {
            return this.frequency;
        }

        public String toString() {
            return zzbg.zzx((Object)((Object)this)).zzg("frequency", (Object)this.frequency).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            FrequencyObjective frequencyObjective = this;
            int n2 = zzbgo.zze((Parcel)parcel2);
            zzbgo.zzc((Parcel)parcel2, (int)1, (int)frequencyObjective.getFrequency());
            zzbgo.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class DurationObjective
    extends zzbgl {
        private final long zzhlg;
        public static final Parcelable.Creator<DurationObjective> CREATOR = new zzp();

        public long getDuration(TimeUnit timeUnit) {
            return timeUnit.convert(this.zzhlg, TimeUnit.NANOSECONDS);
        }

        @Hide
        DurationObjective(long l) {
            this.zzhlg = l;
        }

        public DurationObjective(long l, TimeUnit timeUnit) {
            this(timeUnit.toNanos(l));
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DurationObjective)) {
                return false;
            }
            DurationObjective durationObjective = (DurationObjective)((Object)object);
            return this.zzhlg == durationObjective.zzhlg;
        }

        public int hashCode() {
            return (int)this.zzhlg;
        }

        public String toString() {
            return zzbg.zzx((Object)((Object)this)).zzg("duration", (Object)this.zzhlg).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            DurationObjective durationObjective = this;
            int n2 = zzbgo.zze((Parcel)parcel2);
            zzbgo.zza((Parcel)parcel2, (int)1, (long)durationObjective.zzhlg);
            zzbgo.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class MetricObjective
    extends zzbgl {
        private final String zzhlh;
        private final double value;
        private final double zzhli;
        public static final Parcelable.Creator<MetricObjective> CREATOR = new zzx();

        public String getDataTypeName() {
            return this.zzhlh;
        }

        public double getValue() {
            return this.value;
        }

        public MetricObjective(String string, double d, double d2) {
            this.zzhlh = string;
            this.value = d;
            this.zzhli = d2;
        }

        public MetricObjective(String string, double d) {
            this(string, d, 0.0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MetricObjective)) {
                return false;
            }
            MetricObjective metricObjective = (MetricObjective)((Object)object);
            return zzbg.equal((Object)this.zzhlh, (Object)metricObjective.zzhlh) && this.value == metricObjective.value && this.zzhli == metricObjective.zzhli;
        }

        public int hashCode() {
            return this.zzhlh.hashCode();
        }

        public String toString() {
            return zzbg.zzx((Object)((Object)this)).zzg("dataTypeName", (Object)this.zzhlh).zzg("value", (Object)this.value).zzg("initialValue", (Object)this.zzhli).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            MetricObjective metricObjective = this;
            int n2 = zzbgo.zze((Parcel)parcel2);
            zzbgo.zza((Parcel)parcel2, (int)1, (String)metricObjective.getDataTypeName(), (boolean)false);
            zzbgo.zza((Parcel)parcel2, (int)2, (double)metricObjective.getValue());
            zzbgo.zza((Parcel)parcel2, (int)3, (double)metricObjective.zzhli);
            zzbgo.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class Recurrence
    extends zzbgl {
        public static final int UNIT_DAY = 1;
        public static final int UNIT_WEEK = 2;
        public static final int UNIT_MONTH = 3;
        private final int count;
        private final int zzhlj;
        public static final Parcelable.Creator<Recurrence> CREATOR = new zzab();

        public int getCount() {
            return this.count;
        }

        public int getUnit() {
            return this.zzhlj;
        }

        public Recurrence(int n, int n2) {
            this.count = n;
            zzbq.checkState((n2 > 0 && n2 <= 3 ? 1 : 0) != 0);
            this.zzhlj = n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Recurrence)) {
                return false;
            }
            Recurrence recurrence = (Recurrence)((Object)object);
            return this.count == recurrence.count && this.zzhlj == recurrence.zzhlj;
        }

        public int hashCode() {
            return this.zzhlj;
        }

        public String toString() {
            String string;
            zzbi zzbi2 = zzbg.zzx((Object)((Object)this)).zzg("count", (Object)this.count);
            switch (this.zzhlj) {
                case 1: {
                    string = "day";
                    break;
                }
                case 2: {
                    string = "week";
                    break;
                }
                case 3: {
                    string = "month";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid unit value");
                }
            }
            return zzbi2.zzg("unit", (Object)string).toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Recurrence recurrence = this;
            int n2 = zzbgo.zze((Parcel)parcel2);
            zzbgo.zzc((Parcel)parcel2, (int)1, (int)recurrence.getCount());
            zzbgo.zzc((Parcel)parcel2, (int)2, (int)recurrence.getUnit());
            zzbgo.zzai((Parcel)parcel2, (int)n2);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RecurrenceUnit {
        }
    }
}

