/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.zzac;
import com.google.android.gms.fitness.data.zzad;
import com.google.android.gms.fitness.data.zzb;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.internal.zzfmk;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class Session
extends zzbgl {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final long zzhhl;
    private final long zzhhm;
    private final String name;
    private final String zzhlo;
    private final String description;
    private final int zzhia;
    private final zzb zzhiq;
    @Nullable
    private final Long zzhlp;
    @Hide
    public static final Parcelable.Creator<Session> CREATOR = new zzad();

    @Hide
    public Session(long l, long l2, String string, String string2, String string3, int n, zzb zzb2, @Nullable Long l3) {
        this.zzhhl = l;
        this.zzhhm = l2;
        this.name = string;
        this.zzhlo = string2;
        this.description = string3;
        this.zzhia = n;
        this.zzhiq = zzb2;
        this.zzhlp = l3;
    }

    private Session(Builder builder) {
        this(builder.zzhhl, builder.zzhhm, builder.name, builder.zzhlo, builder.description, builder.zzhia, null, builder.zzhlp);
    }

    @Nullable
    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzbgq.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzhhm, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzbq.zza((this.zzhlp != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzhlp, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzhlp != null;
    }

    public boolean isOngoing() {
        return this.zzhhm == 0L;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getIdentifier() {
        return this.zzhlo;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public String getActivity() {
        return zzfmk.getName(this.zzhia);
    }

    public String getAppPackageName() {
        if (this.zzhiq == null) {
            return null;
        }
        return this.zzhiq.getPackageName();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Session)) {
            return false;
        }
        Session session = (Session)((Object)object);
        return this.zzhhl == session.zzhhl && this.zzhhm == session.zzhhm && zzbg.equal((Object)this.name, (Object)session.name) && zzbg.equal((Object)this.zzhlo, (Object)session.zzhlo) && zzbg.equal((Object)this.description, (Object)session.description) && zzbg.equal((Object)((Object)this.zzhiq), (Object)((Object)session.zzhiq)) && this.zzhia == session.zzhia;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhl, this.zzhhm, this.zzhlo});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("startTime", (Object)this.zzhhl).zzg("endTime", (Object)this.zzhhm).zzg("name", (Object)this.name).zzg("identifier", (Object)this.zzhlo).zzg("description", (Object)this.description).zzg("activity", (Object)this.zzhia).zzg("application", (Object)this.zzhiq).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Session session = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (long)session.zzhhl);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)session.zzhhm);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)session.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)session.getIdentifier(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)session.getDescription(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)7, (int)session.zzhia);
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)session.zzhiq, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (Long)session.zzhlp, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ Session(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private long zzhhl = 0L;
        private long zzhhm = 0L;
        private String name = null;
        private String zzhlo;
        private String description;
        private int zzhia = 4;
        @Nullable
        private Long zzhlp;

        public Builder() {
        }

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzbq.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzhhl = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzbq.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzhhm = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzbq.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.name = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzbq.checkArgument((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzhlo = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzbq.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.description = string;
            return this;
        }

        public Builder setActivity(String string) {
            int n = zzfmk.zzuc(string);
            Builder builder = this;
            this.zzhia = n;
            return builder;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzhlp = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzbq.zza((this.zzhhl > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzbq.zza((this.zzhhm == 0L || this.zzhhm > this.zzhhl ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzhlo == null) {
                String string = this.name == null ? "" : this.name;
                long l = this.zzhhl;
                this.zzhlo = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            if (this.description == null) {
                this.description = "";
            }
            return new Session(this, null);
        }
    }
}

