/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzac;
import com.google.android.gms.fitness.request.zzad;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbwi;
import com.google.android.gms.internal.zzbyt;
import com.google.android.gms.internal.zzbyu;
import com.google.android.gms.internal.zzfmk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoalsReadRequest
extends zzbgl {
    private final zzbyt zzhor;
    private final List<DataType> zzhhz;
    private final List<Integer> zzhos;
    private final List<Integer> zzhla;
    public static final Parcelable.Creator<GoalsReadRequest> CREATOR = new zzad();

    public List<DataType> getDataTypes() {
        return this.zzhhz;
    }

    @Nullable
    public List<Integer> getObjectiveTypes() {
        if (this.zzhos.isEmpty()) {
            return null;
        }
        return this.zzhos;
    }

    @Nullable
    public List<String> getActivityNames() {
        if (this.zzhla.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : this.zzhla) {
            arrayList.add(zzfmk.getName(n));
        }
        return arrayList;
    }

    @Hide
    GoalsReadRequest(IBinder iBinder, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this.zzhor = iBinder == null ? null : zzbyu.zzaw(iBinder);
        this.zzhhz = list;
        this.zzhos = list2;
        this.zzhla = list3;
    }

    private GoalsReadRequest(Builder builder) {
        this((zzbyt)null, (List<DataType>)builder.zzhhz, (List<Integer>)builder.zzhos, (List<Integer>)builder.zzhla);
    }

    @Hide
    public GoalsReadRequest(GoalsReadRequest goalsReadRequest, zzbyt zzbyt2) {
        this(zzbyt2, goalsReadRequest.getDataTypes(), goalsReadRequest.zzhos, goalsReadRequest.zzhla);
    }

    private GoalsReadRequest(zzbyt zzbyt2, List<DataType> list, List<Integer> list2, List<Integer> list3) {
        this(zzbyt2 == null ? null : zzbyt2.asBinder(), list, list2, list3);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GoalsReadRequest)) break block3;
                GoalsReadRequest goalsReadRequest = (GoalsReadRequest)((Object)object);
                GoalsReadRequest goalsReadRequest2 = this;
                if (!(zzbg.equal(goalsReadRequest2.zzhhz, goalsReadRequest.zzhhz) && zzbg.equal(goalsReadRequest2.zzhos, goalsReadRequest.zzhos) && zzbg.equal(goalsReadRequest2.zzhla, goalsReadRequest.zzhla))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhz, this.zzhos, this.getActivityNames()});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("dataTypes", this.zzhhz).zzg("objectiveTypes", this.zzhos).zzg("activities", this.getActivityNames()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoalsReadRequest goalsReadRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (IBinder)goalsReadRequest.zzhor.asBinder(), (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)2, goalsReadRequest.getDataTypes(), (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)3, goalsReadRequest.zzhos, (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)4, goalsReadRequest.zzhla, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ GoalsReadRequest(Builder builder, zzac zzac2) {
        this(builder);
    }

    public static class Builder {
        private final List<DataType> zzhhz = new ArrayList<DataType>();
        private final List<Integer> zzhos = new ArrayList<Integer>();
        private final List<Integer> zzhla = new ArrayList<Integer>();

        public Builder() {
        }

        public Builder addDataType(DataType dataType) {
            zzbq.checkNotNull((Object)((Object)dataType), (Object)"Attempting to use a null data type");
            if (!this.zzhhz.contains((Object)dataType)) {
                this.zzhhz.add(dataType);
            }
            return this;
        }

        public Builder addActivity(String string) {
            int n = zzfmk.zzuc(string);
            zzbq.zza((n != 4 ? 1 : 0) != 0, (Object)"Attempting to add an unknown activity");
            zzbwi.zza(n, this.zzhla);
            return this;
        }

        public Builder addObjectiveType(int n) {
            zzbq.zza((n == 1 || n == 2 || n == 3 ? 1 : 0) != 0, (Object)"Attempting to add an invalid objective type");
            if (!this.zzhos.contains(n)) {
                this.zzhos.add(n);
            }
            return this;
        }

        public GoalsReadRequest build() {
            zzbq.zza((!this.zzhhz.isEmpty() ? 1 : 0) != 0, (Object)"At least one data type should be specified.");
            return new GoalsReadRequest(this, null);
        }
    }
}

