/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzat;
import com.google.android.gms.fitness.request.zzau;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbwh;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzbzu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends zzbgl {
    private final Session zzhhs;
    private final List<DataSet> zzhib;
    private final List<DataPoint> zzhph;
    @Nullable
    private final zzbzt zzhnu;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzau();

    @Hide
    SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.zzhhs = session;
        this.zzhib = Collections.unmodifiableList(list);
        this.zzhph = Collections.unmodifiableList(list2);
        this.zzhnu = zzbzu.zzba(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzhhs, (List<DataSet>)builder.zzhib, (List<DataPoint>)builder.zzhph, (zzbzt)null);
    }

    @Hide
    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzbzt zzbzt2) {
        this(sessionInsertRequest.zzhhs, sessionInsertRequest.zzhib, sessionInsertRequest.zzhph, zzbzt2);
    }

    @Hide
    private SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, @Nullable zzbzt zzbzt2) {
        this.zzhhs = session;
        this.zzhib = Collections.unmodifiableList(list);
        this.zzhph = Collections.unmodifiableList(list2);
        this.zzhnu = zzbzt2;
    }

    public Session getSession() {
        return this.zzhhs;
    }

    public List<DataSet> getDataSets() {
        return this.zzhib;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzhph;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == this) break block2;
                if (!(object instanceof SessionInsertRequest)) break block3;
                SessionInsertRequest sessionInsertRequest = (SessionInsertRequest)((Object)object);
                SessionInsertRequest sessionInsertRequest2 = this;
                if (!(zzbg.equal((Object)((Object)sessionInsertRequest2.zzhhs), (Object)((Object)sessionInsertRequest.zzhhs)) && zzbg.equal(sessionInsertRequest2.zzhib, sessionInsertRequest.zzhib) && zzbg.equal(sessionInsertRequest2.zzhph, sessionInsertRequest.zzhph))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhhs, this.zzhib, this.zzhph});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("session", (Object)this.zzhhs).zzg("dataSets", this.zzhib).zzg("aggregateDataPoints", this.zzhph).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionInsertRequest sessionInsertRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)sessionInsertRequest.getSession(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, sessionInsertRequest.getDataSets(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, sessionInsertRequest.getAggregateDataPoints(), (boolean)false);
        SessionInsertRequest sessionInsertRequest2 = sessionInsertRequest;
        zzbgo.zza((Parcel)parcel2, (int)4, (IBinder)(sessionInsertRequest2.zzhnu == null ? null : sessionInsertRequest2.zzhnu.asBinder()), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ SessionInsertRequest(Builder builder, zzat zzat2) {
        this(builder);
    }

    public static class Builder {
        private Session zzhhs;
        private List<DataSet> zzhib = new ArrayList<DataSet>();
        private List<DataPoint> zzhph = new ArrayList<DataPoint>();
        private List<DataSource> zzhpi = new ArrayList<DataSource>();

        public Builder() {
        }

        public Builder setSession(Session session) {
            this.zzhhs = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzbq.checkArgument((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzbq.zza((!this.zzhpi.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            zzbq.checkArgument((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzhpi.add(dataSource);
            this.zzhib.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzbq.checkArgument((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzbq.zza((!this.zzhpi.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            DataSet.zzb(dataPoint);
            this.zzhpi.add(dataSource);
            this.zzhph.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzbq.zza((this.zzhhs != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzbq.zza((this.zzhhs.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            Builder builder = this;
            Iterator<zzbgl> iterator = builder.zzhib.iterator();
            while (iterator.hasNext()) {
                for (DataPoint dataPoint : iterator.next().getDataPoints()) {
                    builder.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : builder.zzhph) {
                builder.zzd(dataPoint);
            }
            return new SessionInsertRequest(this, null);
        }

        private final void zzd(DataPoint dataPoint) {
            DataPoint dataPoint2 = dataPoint;
            Builder builder = this;
            long l = builder.zzhhs.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = builder.zzhhs.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint2.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzbwh.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbq.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (dataPoint2.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint2.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
            dataPoint2 = dataPoint;
            builder = this;
            l = builder.zzhhs.getStartTime(TimeUnit.NANOSECONDS);
            l2 = builder.zzhhs.getEndTime(TimeUnit.NANOSECONDS);
            l3 = dataPoint2.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint2.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzbwh.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzbq.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint2, l, l2});
                if (l4 != dataPoint2.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint2.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint2.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }
    }
}

