/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzae;
import com.google.android.gms.fitness.request.zzag;
import com.google.android.gms.fitness.request.zzbf;
import com.google.android.gms.fitness.request.zzbg;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbzt;
import com.google.android.gms.internal.zzbzu;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
extends zzbgl {
    private final List<DataType> zzhhz;
    private final zzae zzhpq;
    private final int zzhpr;
    @Nullable
    private final zzbzt zzhnu;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzbg();

    @Hide
    StartBleScanRequest(List<DataType> list, IBinder iBinder, int n, IBinder iBinder2) {
        IInterface iInterface;
        this.zzhhz = list;
        IBinder iBinder3 = iBinder;
        this.zzhpq = iBinder3 == null ? null : ((iInterface = iBinder3.queryLocalInterface("com.google.android.gms.fitness.request.IBleScanCallback")) instanceof zzae ? (zzae)iInterface : new zzag(iBinder3));
        this.zzhpr = n;
        this.zzhnu = zzbzu.zzba(iBinder2);
    }

    private StartBleScanRequest(Builder builder) {
        this((List<DataType>)zzb.zza((Object[])builder.zzhoo), builder.zzhpq, builder.zzhpr, null);
    }

    @Hide
    public StartBleScanRequest(StartBleScanRequest startBleScanRequest, zzbzt zzbzt2) {
        this(startBleScanRequest.zzhhz, startBleScanRequest.zzhpq, startBleScanRequest.zzhpr, zzbzt2);
    }

    @Hide
    public StartBleScanRequest(List<DataType> list, zzae zzae2, int n, @Nullable zzbzt zzbzt2) {
        this.zzhhz = list;
        this.zzhpq = zzae2;
        this.zzhpr = n;
        this.zzhnu = zzbzt2;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzhhz);
    }

    public int getTimeoutSecs() {
        return this.zzhpr;
    }

    public String toString() {
        return com.google.android.gms.common.internal.zzbg.zzx((Object)((Object)this)).zzg("dataTypes", this.zzhhz).zzg("timeoutSecs", (Object)this.zzhpr).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        StartBleScanRequest startBleScanRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, startBleScanRequest.getDataTypes(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (IBinder)startBleScanRequest.zzhpq.asBinder(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)startBleScanRequest.getTimeoutSecs());
        StartBleScanRequest startBleScanRequest2 = startBleScanRequest;
        zzbgo.zza((Parcel)parcel2, (int)4, (IBinder)(startBleScanRequest2.zzhnu == null ? null : startBleScanRequest2.zzhnu.asBinder()), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ StartBleScanRequest(Builder builder, zzbf zzbf2) {
        this(builder);
    }

    public static class Builder {
        private DataType[] zzhoo = new DataType[0];
        private zzae zzhpq;
        private int zzhpr = 10;

        public Builder() {
        }

        public Builder setDataTypes(DataType ... dataTypeArray) {
            this.zzhoo = dataTypeArray;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            zza zza2 = zzd.zzasf().zza(bleScanCallback);
            this.zzhpq = zza2;
            return this;
        }

        public Builder setTimeoutSecs(int n) {
            zzbq.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzbq.checkArgument((n <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzhpr = n;
            return this;
        }

        public StartBleScanRequest build() {
            zzbq.zza((this.zzhpq != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this, null);
        }
    }
}

