/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.result.zzc;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataReadResult
extends zzbgl
implements Result {
    private final List<DataSet> zzhib;
    private final Status zzefs;
    private final List<Bucket> zzhpv;
    private int zzhpw;
    private final List<DataSource> zzhin;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(List<RawDataSet> list, Status status, List<RawBucket> list2, int n, List<DataSource> list3) {
        this.zzefs = status;
        this.zzhpw = n;
        this.zzhin = list3;
        this.zzhib = new ArrayList<DataSet>(list.size());
        for (RawDataSet zzbgl2 : list) {
            this.zzhib.add(new DataSet(zzbgl2, list3));
        }
        this.zzhpv = new ArrayList<Bucket>(list2.size());
        for (RawBucket rawBucket : list2) {
            this.zzhpv.add(new Bucket(rawBucket, list3));
        }
    }

    @Hide
    private DataReadResult(List<DataSet> list, List<Bucket> list2, Status status) {
        this.zzhib = list;
        this.zzefs = status;
        this.zzhpv = list2;
        this.zzhpw = 1;
        this.zzhin = new ArrayList<DataSource>();
    }

    @Hide
    public static DataReadResult zza(Status status, List<DataType> list, List<DataSource> list2) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource zzbgl2 : list2) {
            arrayList.add(DataSet.create(zzbgl2));
        }
        for (DataType dataType : list) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzhib) {
            if (!dataType.equals((Object)dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzhib) {
            if (!dataSource.equals((Object)dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzhib;
    }

    public List<Bucket> getBuckets() {
        return this.zzhpv;
    }

    @Hide
    public final int zzasj() {
        return this.zzhpw;
    }

    @Hide
    public final void zzb(DataReadResult dataReadResult) {
        Iterator<zzbgl> iterator = dataReadResult.getDataSets().iterator();
        while (iterator.hasNext()) {
            DataReadResult.zza(iterator.next(), this.zzhib);
        }
        block1: for (Bucket bucket : dataReadResult.getBuckets()) {
            List<Bucket> list = this.zzhpv;
            Bucket bucket2 = bucket;
            DataReadResult dataReadResult2 = this;
            for (Bucket bucket3 : list) {
                if (!bucket3.zza(bucket2)) continue;
                Iterator<DataSet> iterator2 = bucket2.getDataSets().iterator();
                while (iterator2.hasNext()) {
                    DataReadResult.zza(iterator2.next(), bucket3.getDataSets());
                }
                continue block1;
            }
            dataReadResult2.zzhpv.add(bucket2);
        }
    }

    private static void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals((Object)dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    public Status getStatus() {
        return this.zzefs;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DataReadResult)) break block3;
                DataReadResult dataReadResult = (DataReadResult)((Object)object);
                DataReadResult dataReadResult2 = this;
                if (!(dataReadResult2.zzefs.equals((Object)dataReadResult.zzefs) && zzbg.equal(dataReadResult2.zzhib, dataReadResult.zzhib) && zzbg.equal(dataReadResult2.zzhpv, dataReadResult.zzhpv))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzefs, this.zzhib, this.zzhpv});
    }

    public String toString() {
        Object object;
        Object object2;
        int n;
        zzbi zzbi2 = zzbg.zzx((Object)((Object)this)).zzg("status", (Object)this.zzefs);
        if (this.zzhib.size() > 5) {
            n = this.zzhib.size();
            object2 = new StringBuilder(21).append(n).append(" data sets").toString();
        } else {
            object2 = this.zzhib;
        }
        zzbi zzbi3 = zzbi2.zzg("dataSets", object2);
        if (this.zzhpv.size() > 5) {
            n = this.zzhpv.size();
            object = new StringBuilder(19).append(n).append(" buckets").toString();
        } else {
            object = this.zzhpv;
        }
        return zzbi3.zzg("buckets", object).toString();
    }

    @Hide
    private List<RawBucket> zzask() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzhpv.size());
        for (Bucket bucket : this.zzhpv) {
            arrayList.add(new RawBucket(bucket, this.zzhin));
        }
        return arrayList;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataReadResult dataReadResult = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        DataReadResult dataReadResult2 = dataReadResult;
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(dataReadResult2.zzhib.size());
        for (DataSet dataSet : dataReadResult2.zzhib) {
            arrayList.add(new RawDataSet(dataSet, dataReadResult2.zzhin));
        }
        zzbgo.zzd((Parcel)parcel2, (int)1, arrayList, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)dataReadResult.getStatus(), (int)n, (boolean)false);
        zzbgo.zzd((Parcel)parcel2, (int)3, dataReadResult.zzask(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)dataReadResult.zzhpw);
        zzbgo.zzc((Parcel)parcel2, (int)6, dataReadResult.zzhin, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

