/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzae;
import com.google.android.gms.fitness.result.zzh;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
extends zzbgl
implements Result {
    private final List<Session> zzhny;
    private final List<zzae> zzhpz;
    private final Status zzefs;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzh();

    @Hide
    public SessionReadResult(List<Session> list, List<zzae> list2, Status status) {
        this.zzhny = list;
        this.zzhpz = Collections.unmodifiableList(list2);
        this.zzefs = status;
    }

    @Hide
    public static SessionReadResult zzah(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<zzae> arrayList2 = new ArrayList<zzae>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzhny;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzbq.zzb((boolean)this.zzhny.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzae zzae2 : this.zzhpz) {
            if (!zzbg.equal((Object)((Object)session), (Object)((Object)zzae2.getSession())) || !dataType.equals((Object)zzae2.getDataSet().getDataType())) continue;
            arrayList.add(zzae2.getDataSet());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzbq.zzb((boolean)this.zzhny.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (zzae zzae2 : this.zzhpz) {
            if (!zzbg.equal((Object)((Object)session), (Object)((Object)zzae2.getSession()))) continue;
            arrayList.add(zzae2.getDataSet());
        }
        return arrayList;
    }

    public Status getStatus() {
        return this.zzefs;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionReadResult)) break block3;
                SessionReadResult sessionReadResult = (SessionReadResult)((Object)object);
                SessionReadResult sessionReadResult2 = this;
                if (!(sessionReadResult2.zzefs.equals((Object)sessionReadResult.zzefs) && zzbg.equal(sessionReadResult2.zzhny, sessionReadResult.zzhny) && zzbg.equal(sessionReadResult2.zzhpz, sessionReadResult.zzhpz))) break block3;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzefs, this.zzhny, this.zzhpz});
    }

    public String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("status", (Object)this.zzefs).zzg("sessions", this.zzhny).zzg("sessionDataSets", this.zzhpz).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SessionReadResult sessionReadResult = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, sessionReadResult.getSessions(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, sessionReadResult.zzhpz, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)sessionReadResult.getStatus(), (int)n, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

