/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zzms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int mVersionCode;
    private final List<DataType> zzanw;
    private final List<DataSource> zzapG;
    private final long zzMS;
    private final long zzann;
    private final List<DataType> zzapL;
    private final List<DataSource> zzapM;
    private final int zzanz;
    private final long zzapN;
    private final DataSource zzapO;
    private final int zzapP;
    private final boolean zzapQ;
    private final boolean zzapR;
    private final zzms zzapS;
    private final String zzOZ;
    private final List<Device> zzapT;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzf();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, IBinder callback, String packageName, List<Device> filteredDevices) {
        this.mVersionCode = versionCode;
        this.zzanw = Collections.unmodifiableList(dataTypes);
        this.zzapG = Collections.unmodifiableList(dataSources);
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.zzapL = Collections.unmodifiableList(aggregatedDataTypes);
        this.zzapM = Collections.unmodifiableList(aggregatedDataSources);
        this.zzanz = bucketType;
        this.zzapN = bucketDurationMillis;
        this.zzapO = activityDataSource;
        this.zzapP = limit;
        this.zzapQ = flushBeforeRead;
        this.zzapR = serverQueriesEnabled;
        this.zzapS = callback == null ? null : zzms.zza.zzbu(callback);
        this.zzOZ = packageName;
        this.zzapT = filteredDevices == null ? Collections.EMPTY_LIST : filteredDevices;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzanw, builder.zzapG, builder.zzMS, builder.zzann, builder.zzapL, builder.zzapM, builder.zzanz, builder.zzapN, builder.zzapO, builder.zzapP, builder.zzapQ, builder.zzapR, null, null, builder.zzapT);
    }

    public DataReadRequest(DataReadRequest request, zzms callback, String packageName) {
        this(request.zzanw, request.zzapG, request.zzMS, request.zzann, request.zzapL, request.zzapM, request.zzanz, request.zzapN, request.zzapO, request.zzapP, request.zzapQ, request.zzapR, callback, packageName, request.zzapT);
    }

    public DataReadRequest(List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, zzms callback, String packageName, List<Device> filteredDevices) {
        this.mVersionCode = 4;
        this.zzanw = Collections.unmodifiableList(dataTypes);
        this.zzapG = Collections.unmodifiableList(dataSources);
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.zzapL = Collections.unmodifiableList(aggregatedDataTypes);
        this.zzapM = Collections.unmodifiableList(aggregatedDataSources);
        this.zzanz = bucketType;
        this.zzapN = bucketDurationMillis;
        this.zzapO = activityDataSource;
        this.zzapP = limit;
        this.zzapQ = flushBeforeRead;
        this.zzapR = serverQueriesEnabled;
        this.zzapS = callback;
        this.zzOZ = packageName;
        this.zzapT = filteredDevices;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzMS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzann, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzanw;
    }

    public List<DataSource> getDataSources() {
        return this.zzapG;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzapL;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzapM;
    }

    public int getBucketType() {
        return this.zzanz;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzapN, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzapO;
    }

    public int getLimit() {
        return this.zzapP;
    }

    public boolean zzsh() {
        return this.zzapR;
    }

    public boolean zzsi() {
        return this.zzapQ;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.zzb((DataReadRequest)that);
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzanw.equals(dataReadRequest.zzanw) && this.zzapG.equals(dataReadRequest.zzapG) && this.zzMS == dataReadRequest.zzMS && this.zzann == dataReadRequest.zzann && this.zzanz == dataReadRequest.zzanz && this.zzapM.equals(dataReadRequest.zzapM) && this.zzapL.equals(dataReadRequest.zzapL) && zzw.equal((Object)this.zzapO, (Object)dataReadRequest.zzapO) && this.zzapN == dataReadRequest.zzapN && this.zzapR == dataReadRequest.zzapR;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanz, this.zzMS, this.zzann});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzanw.isEmpty()) {
            for (DataType object : this.zzanw) {
                stringBuilder.append(object.zzrH()).append(" ");
            }
        }
        if (!this.zzapG.isEmpty()) {
            for (DataSource dataSource : this.zzapG) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzanz != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzel(this.zzanz));
            if (this.zzapN > 0L) {
                stringBuilder.append(" >").append(this.zzapN).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzapL.isEmpty()) {
            for (DataType dataType : this.zzapL) {
                stringBuilder.append(dataType.zzrH()).append(" ");
            }
        }
        if (!this.zzapM.isEmpty()) {
            for (DataSource dataSource : this.zzapM) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzMS, this.zzMS, this.zzann, this.zzann));
        if (this.zzapO != null) {
            stringBuilder.append("activities: ").append(this.zzapO.toDebugString());
        }
        if (this.zzapR) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzrw() {
        return this.zzann;
    }

    public long zzkH() {
        return this.zzMS;
    }

    public long zzsj() {
        return this.zzapN;
    }

    public IBinder zzsc() {
        return this.zzapS == null ? null : this.zzapS.asBinder();
    }

    public String getPackageName() {
        return this.zzOZ;
    }

    public List<Device> zzsk() {
        return this.zzapT;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> zzanw = new ArrayList<DataType>();
        private List<DataSource> zzapG = new ArrayList<DataSource>();
        private List<DataType> zzapL = new ArrayList<DataType>();
        private List<DataSource> zzapM = new ArrayList<DataSource>();
        private DataSource zzapO;
        private long zzMS;
        private long zzann;
        private int zzanz = 0;
        private long zzapN = 0L;
        private int zzapP = 0;
        private boolean zzapQ = false;
        private boolean zzapR = false;
        private List<Device> zzapT = new ArrayList<Device>();

        public Builder read(DataSource dataSource) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zzb((!this.zzapM.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzapG.contains(dataSource)) {
                this.zzapG.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzapL.contains(dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzanw.contains(dataType)) {
                this.zzanw.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzx.zza((!this.zzapG.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(dataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, outputDataType});
            if (!this.zzapM.contains(dataSource)) {
                this.zzapM.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            zzx.zzb((Object)inputDataType, (Object)"Attempting to use a null data type");
            zzx.zza((!this.zzanw.contains(inputDataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzx.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{inputDataType});
            zzx.zzb((boolean)DataType.getAggregatesForInput(inputDataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{inputDataType, outputDataType});
            if (!this.zzapL.contains(inputDataType)) {
                this.zzapL.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            zzx.zzb((this.zzanz == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzanz});
            zzx.zzb((duration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{duration});
            this.zzanz = 1;
            this.zzapN = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzanz == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzanz});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzanz = 3;
            this.zzapN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzanz == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzanz});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzapO = activityDataSource;
            this.zzanz = 3;
            this.zzapN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzanz == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzanz});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzanz = 4;
            this.zzapN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzx.zzb((this.zzanz == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzanz});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzx.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzx.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzapO = activityDataSource;
            this.zzanz = 4;
            this.zzapN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            zzx.zzb((this.zzanz == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzanz});
            zzx.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzanz = 2;
            this.zzapN = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.zzMS = timeUnit.toMillis(start);
            this.zzann = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzapR = true;
            return this;
        }

        public Builder setLimit(int limit) {
            zzx.zzb((limit > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{limit});
            this.zzapP = limit;
            return this;
        }

        public DataReadRequest build() {
            zzx.zza((!this.zzapG.isEmpty() || !this.zzanw.isEmpty() || !this.zzapM.isEmpty() || !this.zzapL.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzx.zza((this.zzMS > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzMS});
            zzx.zza((this.zzann > 0L && this.zzann > this.zzMS ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzann});
            boolean bl = this.zzapM.isEmpty() && this.zzapL.isEmpty();
            zzx.zza((bl && this.zzanz == 0 || !bl && this.zzanz != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

