/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.SessionInsertRequest;
import com.google.android.gms.fitness.request.SessionReadRequest;
import com.google.android.gms.fitness.result.SessionReadResult;
import com.google.android.gms.fitness.result.SessionStopResult;

public interface SessionsApi {
    public PendingResult<Status> startSession(GoogleApiClient var1, Session var2);

    public PendingResult<SessionStopResult> stopSession(GoogleApiClient var1, String var2);

    public PendingResult<Status> insertSession(GoogleApiClient var1, SessionInsertRequest var2);

    public PendingResult<SessionReadResult> readSession(GoogleApiClient var1, SessionReadRequest var2);

    public PendingResult<Status> registerForSessions(GoogleApiClient var1, PendingIntent var2);

    public PendingResult<Status> unregisterForSessions(GoogleApiClient var1, PendingIntent var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private Session zzapP;
        private String zzapO;
        private boolean zzapQ = false;

        public ViewIntentBuilder(Context context) {
            this.mContext = context;
        }

        public ViewIntentBuilder setSession(Session session) {
            this.zzapP = session;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.zzapO = packageName;
            this.zzapQ = true;
            return this;
        }

        public Intent build() {
            zzx.zza((this.zzapP != null ? 1 : 0) != 0, (Object)"Session must be set");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(Session.getMimeType(this.zzapP.getActivity()));
            zzc.zza((SafeParcelable)this.zzapP, (Intent)intent, (String)"vnd.google.fitness.session");
            if (!this.zzapQ) {
                this.zzapO = this.zzapP.getAppPackageName();
            }
            return this.zzj(intent);
        }

        private Intent zzj(Intent intent) {
            if (this.zzapO == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzapO);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzapO, string));
                return intent2;
            }
            return intent;
        }
    }
}

