/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.request.SensorRequest;
import com.google.android.gms.fitness.request.zzs;
import com.google.android.gms.internal.zzoj;
import com.google.android.gms.location.LocationRequest;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SensorRegistrationRequest
implements SafeParcelable {
    private final int mVersionCode;
    private DataSource zzapM;
    private DataType zzapL;
    private zzj zzasF;
    int zzasG;
    int zzasH;
    private final long zzarc;
    private final long zzasI;
    private final PendingIntent mPendingIntent;
    private final long zzasJ;
    private final int zzard;
    private final List<LocationRequest> zzasK;
    private final long zzasL;
    private final List<Object> zzasM;
    private final zzoj zzasb;
    public static final Parcelable.Creator<SensorRegistrationRequest> CREATOR = new zzs();

    SensorRegistrationRequest(int versionCode, DataSource dataSource, DataType dataType, IBinder listenerBinder, int samplingIntervalMicrosInt, int maxDeliveryLatencyMicrosInt, long samplingIntervalMicros, long maxDeliveryLatencyMicros, PendingIntent intent, long fastestIntervalMicros, int accuracyMode, List<LocationRequest> locationRequests, long registrationTimeOutMicros, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzapM = dataSource;
        this.zzapL = dataType;
        this.zzasF = listenerBinder == null ? null : zzj.zza.zzbl(listenerBinder);
        this.zzarc = samplingIntervalMicros == 0L ? (long)samplingIntervalMicrosInt : samplingIntervalMicros;
        this.zzasJ = fastestIntervalMicros;
        this.zzasI = maxDeliveryLatencyMicros == 0L ? (long)maxDeliveryLatencyMicrosInt : maxDeliveryLatencyMicros;
        this.zzasK = locationRequests;
        this.mPendingIntent = intent;
        this.zzard = accuracyMode;
        this.zzasM = Collections.emptyList();
        this.zzasL = registrationTimeOutMicros;
        this.zzasb = zzoj.zza.zzbJ(callback);
    }

    public SensorRegistrationRequest(SensorRequest request, zzj listener, PendingIntent intent, zzoj callback) {
        this(request.getDataSource(), request.getDataType(), listener, intent, request.getSamplingRate(TimeUnit.MICROSECONDS), request.getFastestRate(TimeUnit.MICROSECONDS), request.getMaxDeliveryLatency(TimeUnit.MICROSECONDS), request.getAccuracyMode(), null, Collections.emptyList(), request.zztg(), callback);
    }

    public SensorRegistrationRequest(DataSource dataSource, DataType dataType, zzj listener, PendingIntent pendingIntent, long samplingIntervalMicros, long fastestIntervalMicros, long maxDeliveryLatencyMicros, int accuracyMode, List<LocationRequest> locationRequests, List<Object> clientIdentities, long registrationTimeOutMicros, zzoj callback) {
        this.mVersionCode = 6;
        this.zzapM = dataSource;
        this.zzapL = dataType;
        this.zzasF = listener;
        this.mPendingIntent = pendingIntent;
        this.zzarc = samplingIntervalMicros;
        this.zzasJ = fastestIntervalMicros;
        this.zzasI = maxDeliveryLatencyMicros;
        this.zzard = accuracyMode;
        this.zzasK = locationRequests;
        this.zzasM = clientIdentities;
        this.zzasL = registrationTimeOutMicros;
        this.zzasb = callback;
    }

    public DataSource getDataSource() {
        return this.zzapM;
    }

    public DataType getDataType() {
        return this.zzapL;
    }

    public PendingIntent zzta() {
        return this.mPendingIntent;
    }

    public long zztb() {
        return this.zzasJ;
    }

    public long zzsB() {
        return this.zzarc;
    }

    public long zztc() {
        return this.zzasI;
    }

    public List<LocationRequest> zztd() {
        return this.zzasK;
    }

    public int getAccuracyMode() {
        return this.zzard;
    }

    public long zzte() {
        return this.zzasL;
    }

    public IBinder zzsO() {
        return this.zzasb == null ? null : this.zzasb.asBinder();
    }

    public String toString() {
        return String.format("SensorRegistrationRequest{type %s source %s interval %s fastest %s latency %s}", this.zzapL, this.zzapM, this.zzarc, this.zzasJ, this.zzasI);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zztf() {
        return this.zzasF == null ? null : this.zzasF.asBinder();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzs.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRegistrationRequest && this.zzb((SensorRegistrationRequest)that);
    }

    private boolean zzb(SensorRegistrationRequest sensorRegistrationRequest) {
        return zzw.equal((Object)this.zzapM, (Object)sensorRegistrationRequest.zzapM) && zzw.equal((Object)this.zzapL, (Object)sensorRegistrationRequest.zzapL) && this.zzarc == sensorRegistrationRequest.zzarc && this.zzasJ == sensorRegistrationRequest.zzasJ && this.zzasI == sensorRegistrationRequest.zzasI && this.zzard == sensorRegistrationRequest.zzard && zzw.equal(this.zzasK, sensorRegistrationRequest.zzasK);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzapM, this.zzapL, this.zzasF, this.zzarc, this.zzasJ, this.zzasI, this.zzard, this.zzasK});
    }
}

