/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzaa;
import com.google.android.gms.fitness.request.zzn;
import com.google.android.gms.internal.zzmj;
import com.google.android.gms.internal.zzoj;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzapW;
    private final zzn zzasY;
    private final int zzasZ;
    private final zzoj zzasb;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzaa();

    StartBleScanRequest(int versionCode, List<DataType> dataTypes, IBinder bleScanCallback, int timeoutSecs, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzapW = dataTypes;
        this.zzasY = zzn.zza.zzbM(bleScanCallback);
        this.zzasZ = timeoutSecs;
        this.zzasb = zzoj.zza.zzbJ(callback);
    }

    private StartBleScanRequest(Builder builder) {
        this(zzmj.zzb((Object[])builder.zzasw), builder.zzasY, builder.zzasZ, null);
    }

    public StartBleScanRequest(StartBleScanRequest request, zzoj callback) {
        this(request.zzapW, request.zzasY, request.zzasZ, callback);
    }

    public StartBleScanRequest(List<DataType> dataTypes, zzn bleScanCallback, int timeoutSecs, zzoj callback) {
        this.mVersionCode = 4;
        this.zzapW = dataTypes;
        this.zzasY = bleScanCallback;
        this.zzasZ = timeoutSecs;
        this.zzasb = callback;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzapW);
    }

    public int getTimeoutSecs() {
        return this.zzasZ;
    }

    public IBinder zztk() {
        return this.zzasY.asBinder();
    }

    public IBinder zzsO() {
        return this.zzasb == null ? null : this.zzasb.asBinder();
    }

    public String toString() {
        return zzw.zzv((Object)this).zzg("dataTypes", this.zzapW).zzg("timeoutSecs", (Object)this.zzasZ).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzaa.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzasw = new DataType[0];
        private zzn zzasY;
        private int zzasZ = 10;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzasw = dataTypes;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzsM().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzn zzn2) {
            this.zzasY = zzn2;
            return this;
        }

        public Builder setTimeoutSecs(int stopTimeSecs) {
            zzx.zzb((stopTimeSecs > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzx.zzb((stopTimeSecs <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzasZ = stopTimeSecs;
            return this;
        }

        public StartBleScanRequest build() {
            zzx.zza((this.zzasY != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

