/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzd;
import com.google.android.gms.internal.zzol;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzatP;
    private long zzaue;
    private long zzauf;
    private final Value[] zzaug;
    private DataSource zzauh;
    private long zzaui;
    private long zzauj;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzd();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzatP = dataSource;
        this.zzauh = originalDataSource;
        this.zzaue = timestampNanos;
        this.zzauf = startTimeNanos;
        this.zzaug = values;
        this.zzaui = rawTimestamp;
        this.zzauj = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(DataPoint.zza(dataSources, rawDataPoint.zzauX), DataPoint.zza(dataSources, rawDataPoint.zzauY), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource originalDataSource, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzaue, 0L), DataPoint.zza(rawDataPoint.zzauf, 0L), rawDataPoint.zzaug, originalDataSource, DataPoint.zza(rawDataPoint.zzaui, 0L), DataPoint.zza(rawDataPoint.zzauj, 0L));
    }

    private static DataSource zza(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.mVersionCode = 4;
        this.zzatP = (DataSource)zzx.zzb((Object)dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzaug = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzaug[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzc.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.zzaue = timeUnit.toNanos(timestamp);
        if (this.zztC() && zzol.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzaue = zzol.zza(this.zzaue, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zztC() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.zzauf = timeUnit.toNanos(startTime);
        this.zzaue = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzaug[n];
    }

    public Value[] zztD() {
        return this.zzaug;
    }

    public DataPoint setFloatValues(float ... values) {
        this.zzeK(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzaug[i].setFloat(values[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.zzeK(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzaug[i].setInt(values[i]);
        }
        return this;
    }

    private void zzeK(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzx.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.zzatP.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzatP;
    }

    public DataSource getOriginalDataSource() {
        return this.zzauh;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaue, TimeUnit.NANOSECONDS);
    }

    public long zztE() {
        return this.zzaui;
    }

    public long zztF() {
        return this.zzauj;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzauf, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaue, TimeUnit.NANOSECONDS);
    }

    public void zztG() {
        DataSource dataSource = this.getDataSource();
        zzx.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzx.zzb((this.zzaue > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzx.zzb((this.zzauf <= this.zzaue ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DataPoint && this.zza((DataPoint)o);
    }

    private boolean zza(DataPoint dataPoint) {
        return zzw.equal((Object)this.zzatP, (Object)dataPoint.zzatP) && this.zzaue == dataPoint.zzaue && this.zzauf == dataPoint.zzauf && Arrays.equals(this.zzaug, dataPoint.zzaug) && zzw.equal((Object)this.zzauh, (Object)dataPoint.zzauh);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzatP, this.zzaue, this.zzauf});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.zzaug), this.zzauf, this.zzaue, this.zzaui, this.zzauj, this.zzatP.toDebugString(), this.zzauh != null ? this.zzauh.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getTimestampNanos() {
        return this.zzaue;
    }

    public long zztH() {
        return this.zzauf;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzd.zza(this, parcel, flags);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

