/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.zzp;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int mVersionCode;
    private final long zzQj;
    private final long zzatQ;
    private final String mName;
    private final String zzavb;
    private final String zzavc;
    private final int zzaua;
    private final Application zzaun;
    private final Long zzavd;
    public static final Parcelable.Creator<Session> CREATOR = new zzp();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzQj = startTimeMillis;
        this.zzatQ = endTimeMillis;
        this.mName = name;
        this.zzavb = identifier;
        this.zzavc = description;
        this.zzaua = activityType;
        this.zzaun = application;
        this.zzavd = activeTimeMillis;
    }

    public Session(long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this(3, startTimeMillis, endTimeMillis, name, identifier, description, activityType, application, activeTimeMillis);
    }

    private Session(Builder builder) {
        this(builder.zzQj, builder.zzatQ, builder.mName, builder.zzavb, builder.zzavc, builder.zzaua, builder.zzaun, builder.zzavd);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzc.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzQj, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzatQ, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzx.zza((this.zzavd != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzavd, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzavd != null;
    }

    public boolean isOngoing() {
        return this.zzatQ == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzavb;
    }

    public String getDescription() {
        return this.zzavc;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzaua);
    }

    public int zztz() {
        return this.zzaua;
    }

    public Application zztK() {
        return this.zzaun;
    }

    public String getAppPackageName() {
        return this.zzaun == null ? null : this.zzaun.getPackageName();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Session && this.zza((Session)o);
    }

    private boolean zza(Session session) {
        return this.zzQj == session.zzQj && this.zzatQ == session.zzatQ && zzw.equal((Object)this.mName, (Object)session.mName) && zzw.equal((Object)this.zzavb, (Object)session.zzavb) && zzw.equal((Object)this.zzavc, (Object)session.zzavc) && zzw.equal((Object)this.zzaun, (Object)session.zzaun) && this.zzaua == session.zzaua;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzQj, this.zzatQ, this.zzavb});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("startTime", (Object)this.zzQj).zzg("endTime", (Object)this.zzatQ).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzavb).zzg("description", (Object)this.zzavc).zzg("activity", (Object)this.zzaua).zzg("application", (Object)this.zzaun).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzlx() {
        return this.zzQj;
    }

    public long zztB() {
        return this.zzatQ;
    }

    public Long zztS() {
        return this.zzavd;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzp.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzQj = 0L;
        private long zzatQ = 0L;
        private String mName = null;
        private String zzavb;
        private String zzavc;
        private int zzaua = 4;
        private Application zzaun;
        private Long zzavd;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            zzx.zza((time > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzQj = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            zzx.zza((time >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzatQ = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            zzx.zzb((name.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            zzx.zzab((identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0 ? 1 : 0) != 0);
            this.zzavb = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            zzx.zzb((description.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzavc = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.zzeV(FitnessActivities.zzdd(activity));
        }

        public Builder zzeV(int n) {
            this.zzaua = n;
            return this;
        }

        public Builder setActiveTime(long time, TimeUnit timeUnit) {
            this.zzavd = timeUnit.toMillis(time);
            return this;
        }

        public Session build() {
            zzx.zza((this.zzQj > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzx.zza((this.zzatQ == 0L || this.zzatQ > this.zzQj ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzavb == null) {
                this.zzavb = (this.mName == null ? "" : this.mName) + this.zzQj;
            }
            return new Session(this);
        }
    }
}

