/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zzpp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final long zzQj;
    private final long zzatQ;
    private final List<DataSource> zzayl;
    private final List<DataType> zzatZ;
    private final List<Session> zzaym;
    private final boolean zzayn;
    private final boolean zzayo;
    private final zzpp zzayj;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzQj = startTimeMillis;
        this.zzatQ = endTimeMillis;
        this.zzayl = Collections.unmodifiableList(dataSources);
        this.zzatZ = Collections.unmodifiableList(dataTypes);
        this.zzaym = sessions;
        this.zzayn = deleteAllData;
        this.zzayo = deleteAllSessions;
        this.zzayj = zzpp.zza.zzbR(callback);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzQj, builder.zzatQ, builder.zzayl, builder.zzatZ, builder.zzaym, builder.zzayn, builder.zzayo, null);
    }

    public DataDeleteRequest(DataDeleteRequest request, zzpp callback) {
        this(request.zzQj, request.zzatQ, request.zzayl, request.zzatZ, request.zzaym, request.zzayn, request.zzayo, callback);
    }

    public DataDeleteRequest(long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, zzpp callback) {
        this.mVersionCode = 3;
        this.zzQj = startTimeMillis;
        this.zzatQ = endTimeMillis;
        this.zzayl = Collections.unmodifiableList(dataSources);
        this.zzatZ = Collections.unmodifiableList(dataTypes);
        this.zzaym = sessions;
        this.zzayn = deleteAllData;
        this.zzayo = deleteAllSessions;
        this.zzayj = callback;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzQj, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzatQ, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzayl;
    }

    public List<DataType> getDataTypes() {
        return this.zzatZ;
    }

    public List<Session> getSessions() {
        return this.zzaym;
    }

    public boolean deleteAllData() {
        return this.zzayn;
    }

    public boolean deleteAllSessions() {
        return this.zzayo;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)o);
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzQj == dataDeleteRequest.zzQj && this.zzatQ == dataDeleteRequest.zzatQ && zzw.equal(this.zzayl, dataDeleteRequest.zzayl) && zzw.equal(this.zzatZ, dataDeleteRequest.zzatZ) && zzw.equal(this.zzaym, dataDeleteRequest.zzaym) && this.zzayn == dataDeleteRequest.zzayn && this.zzayo == dataDeleteRequest.zzayo;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzQj, this.zzatQ});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("startTimeMillis", (Object)this.zzQj).zzg("endTimeMillis", (Object)this.zzatQ).zzg("dataSources", this.zzayl).zzg("dateTypes", this.zzatZ).zzg("sessions", this.zzaym).zzg("deleteAllData", (Object)this.zzayn).zzg("deleteAllSessions", (Object)this.zzayo).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean zzuj() {
        return this.zzayn;
    }

    public boolean zzuk() {
        return this.zzayo;
    }

    public long zztB() {
        return this.zzatQ;
    }

    public long zzlx() {
        return this.zzQj;
    }

    public IBinder zzui() {
        return this.zzayj == null ? null : this.zzayj.asBinder();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzd.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzQj;
        private long zzatQ;
        private List<DataSource> zzayl = new ArrayList<DataSource>();
        private List<DataType> zzatZ = new ArrayList<DataType>();
        private List<Session> zzaym = new ArrayList<Session>();
        private boolean zzayn = false;
        private boolean zzayo = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            zzx.zzb((startTime > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{startTime});
            zzx.zzb((endTime > startTime ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{endTime});
            this.zzQj = timeUnit.toMillis(startTime);
            this.zzatQ = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            zzx.zzb((boolean)this.zzatZ.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzx.zzb((boolean)this.zzayl.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzayn = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzx.zzb((!this.zzayn ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzx.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzatZ.contains(dataType)) {
                this.zzatZ.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzx.zzb((!this.zzayn ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzx.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzayl.contains(dataSource)) {
                this.zzayl.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzx.zzb((!this.zzayo ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzx.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzx.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzaym.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzx.zzb((boolean)this.zzaym.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzayo = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzx.zza((this.zzQj > 0L && this.zzatQ > this.zzQj ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzayn || !this.zzayl.isEmpty() || !this.zzatZ.isEmpty();
            boolean bl2 = this.zzayo || !this.zzaym.isEmpty();
            zzx.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzul();
            return new DataDeleteRequest(this);
        }

        private void zzul() {
            if (this.zzaym.isEmpty()) {
                return;
            }
            for (Session session : this.zzaym) {
                zzx.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzQj && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzatQ ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzQj, this.zzatQ});
            }
        }
    }
}

