/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzh;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzpb;
import java.util.Arrays;
import java.util.List;

public class DataSourcesRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzatZ;
    private final List<Integer> zzayB;
    private final boolean zzayC;
    private final zzpb zzayD;
    public static final Parcelable.Creator<DataSourcesRequest> CREATOR = new zzh();

    DataSourcesRequest(int versionCode, List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzatZ = dataTypes;
        this.zzayB = dataSourceTypes;
        this.zzayC = includeDbOnlySources;
        this.zzayD = zzpb.zza.zzbD(callback);
    }

    private DataSourcesRequest(Builder builder) {
        this(zznh.zzb((Object[])builder.zzayE), Arrays.asList(zznh.zza((int[])builder.zzayF)), builder.zzayC, null);
    }

    public DataSourcesRequest(DataSourcesRequest request, zzpb callback) {
        this(request.zzatZ, request.zzayB, request.zzayC, callback);
    }

    public DataSourcesRequest(List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, zzpb callback) {
        this.mVersionCode = 4;
        this.zzatZ = dataTypes;
        this.zzayB = dataSourceTypes;
        this.zzayC = includeDbOnlySources;
        this.zzayD = callback;
    }

    public List<DataType> getDataTypes() {
        return this.zzatZ;
    }

    public List<Integer> zzur() {
        return this.zzayB;
    }

    public boolean zzus() {
        return this.zzayC;
    }

    public IBinder zzui() {
        return this.zzayD == null ? null : this.zzayD.asBinder();
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzx((Object)this).zzg("dataTypes", this.zzatZ).zzg("sourceTypes", this.zzayB);
        if (this.zzayC) {
            zza2.zzg("includeDbOnlySources", (Object)"true");
        }
        return zza2.toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzayE = new DataType[0];
        private int[] zzayF = new int[]{0, 1};
        private boolean zzayC = false;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzayE = dataTypes;
            return this;
        }

        public Builder setDataSourceTypes(int ... dataSourceTypes) {
            this.zzayF = dataSourceTypes;
            return this;
        }

        public DataSourcesRequest build() {
            zzx.zza((this.zzayE.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data type");
            zzx.zza((this.zzayF.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data source type");
            return new DataSourcesRequest(this);
        }
    }
}

