/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSourcesResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<DataSource> zzayl;
    private final Status zzTA;
    public static final Parcelable.Creator<DataSourcesResult> CREATOR = new zze();

    DataSourcesResult(int versionCode, List<DataSource> dataSources, Status status) {
        this.mVersionCode = versionCode;
        this.zzayl = Collections.unmodifiableList(dataSources);
        this.zzTA = status;
    }

    public DataSourcesResult(List<DataSource> dataSources, Status status) {
        this.mVersionCode = 3;
        this.zzayl = Collections.unmodifiableList(dataSources);
        this.zzTA = status;
    }

    public static DataSourcesResult zzS(Status status) {
        return new DataSourcesResult(Collections.emptyList(), status);
    }

    public List<DataSource> getDataSources() {
        return this.zzayl;
    }

    public List<DataSource> getDataSources(DataType dataType) {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        for (DataSource dataSource : this.zzayl) {
            if (!dataSource.getDataType().equals(dataType)) continue;
            arrayList.add(dataSource);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzTA;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSourcesResult && this.zzb((DataSourcesResult)that);
    }

    private boolean zzb(DataSourcesResult dataSourcesResult) {
        return this.zzTA.equals((Object)dataSourcesResult.zzTA) && zzw.equal(this.zzayl, dataSourcesResult.zzayl);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzTA, this.zzayl});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("status", (Object)this.zzTA).zzg("dataSets", this.zzayl).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags);
    }
}

