/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<Subscription> zzazs;
    private final Status zzTA;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzh();

    ListSubscriptionsResult(int versionCode, List<Subscription> subscriptions, Status status) {
        this.mVersionCode = versionCode;
        this.zzazs = subscriptions;
        this.zzTA = status;
    }

    public ListSubscriptionsResult(List<Subscription> subscriptions, Status status) {
        this.mVersionCode = 3;
        this.zzazs = Collections.unmodifiableList(subscriptions);
        this.zzTA = (Status)zzx.zzb((Object)status, (Object)"status");
    }

    public static ListSubscriptionsResult zzU(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzazs;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzazs) {
            if (!dataType.equals(subscription.zztV())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzTA;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)that);
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.zzTA.equals((Object)listSubscriptionsResult.zzTA) && zzw.equal(this.zzazs, listSubscriptionsResult.zzazs);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzTA, this.zzazs});
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("status", (Object)this.zzTA).zzg("subscriptions", this.zzazs).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

