/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzj;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zza;
import com.google.android.gms.fitness.service.zzb;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
implements SafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int mVersionCode;
    private final DataSource zzatP;
    private final zzj zzayN;
    private final long zzazx;
    private final long zzazy;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zza();

    FitnessSensorServiceRequest(int versionCode, DataSource dataSource, IBinder listenerBinder, long samplingRateMicros, long batchIntervalMicros) {
        this.mVersionCode = versionCode;
        this.zzatP = dataSource;
        this.zzayN = zzj.zza.zzbt(listenerBinder);
        this.zzazx = samplingRateMicros;
        this.zzazy = batchIntervalMicros;
    }

    public DataSource getDataSource() {
        return this.zzatP;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzb(this.zzayN);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.zzazx == -1L ? -1L : timeUnit.convert(this.zzazx, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzazy, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", this.zzatP);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzuz() {
        return this.zzayN.asBinder();
    }

    public long zztU() {
        return this.zzazx;
    }

    public long zzuQ() {
        return this.zzazy;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zza.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FitnessSensorServiceRequest && this.zza((FitnessSensorServiceRequest)that);
    }

    private boolean zza(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return zzw.equal((Object)this.zzatP, (Object)fitnessSensorServiceRequest.zzatP) && this.zzazx == fitnessSensorServiceRequest.zzazx && this.zzazy == fitnessSensorServiceRequest.zzazy;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzatP, this.zzazx, this.zzazy});
    }
}

