/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DailyTotalRequest;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataInsertRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.internal.zzoz;
import com.google.android.gms.internal.zzpa;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.internal.zzqa;

public class zzpv
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient client, DataSet dataSet) {
        return this.zza(client, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzx.zzb((Object)dataSet, (Object)"Must set the data set");
        zzx.zza((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"Cannot use an empty data set");
        zzx.zzb((Object)dataSet.getDataSource().zztK(), (Object)"Must set the app package name for the data source");
        return googleApiClient.zza((zzlx.zza)new zzou.zzc(googleApiClient){

            protected void zza(zzou zzou2) throws RemoteException {
                zzqa zzqa2 = new zzqa((zzlx.zzb<Status>)this);
                ((zzpf)zzou2.zzqs()).zza(new DataInsertRequest(dataSet, zzqa2, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient client, final DataDeleteRequest request) {
        return client.zza((zzlx.zza)new zzou.zzc(client){

            protected void zza(zzou zzou2) throws RemoteException {
                zzqa zzqa2 = new zzqa((zzlx.zzb<Status>)this);
                ((zzpf)zzou2.zzqs()).zza(new DataDeleteRequest(request, zzqa2));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient client, final DataReadRequest request) {
        return client.zza((zzlx.zza)new zzou.zza<DataReadResult>(client){

            protected void zza(zzou zzou2) throws RemoteException {
                zza zza2 = new zza((zzlx.zzb)this);
                ((zzpf)zzou2.zzqs()).zza(new DataReadRequest(request, zza2));
            }

            protected DataReadResult zzL(Status status) {
                return DataReadResult.zza(status, request);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzL(status);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient client, final DataType dataType) {
        return client.zza((zzlx.zza)new zzou.zza<DailyTotalResult>(client){

            protected void zza(zzou zzou2) throws RemoteException {
                zzoz.zza zza2 = new zzoz.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.zzb(dailyTotalResult);
                    }
                };
                DailyTotalRequest dailyTotalRequest = new DailyTotalRequest(zza2, dataType);
                ((zzpf)zzou2.zzqs()).zza(dailyTotalRequest);
            }

            protected DailyTotalResult zzM(Status status) {
                return DailyTotalResult.zza(status, dataType);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzM(status);
            }
        });
    }

    private static class zza
    extends zzpa.zza {
        private final zzlx.zzb<DataReadResult> zzakL;
        private int zzaxI = 0;
        private DataReadResult zzaxJ = null;

        private zza(zzlx.zzb<DataReadResult> zzb2) {
            this.zzakL = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                if (Log.isLoggable((String)"Fitness", (int)2)) {
                    Log.v((String)"Fitness", (String)("Received batch result " + this.zzaxI));
                }
                if (this.zzaxJ == null) {
                    this.zzaxJ = dataReadResult;
                } else {
                    this.zzaxJ.zzb(dataReadResult);
                }
                ++this.zzaxI;
                if (this.zzaxI == this.zzaxJ.zzuH()) {
                    this.zzakL.zzr((Object)this.zzaxJ);
                }
            }
        }
    }
}

