/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public PendingResult<Status> updateData(GoogleApiClient var1, DataUpdateRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType zzavT;
        private DataSource zzavU;
        private long zzRD;
        private long zzavV;
        private String zzavW;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.zzavT = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long start, long end, TimeUnit timeUnit) {
            this.zzRD = timeUnit.toMillis(start);
            this.zzavV = timeUnit.toMillis(end);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzx.zzb((boolean)dataSource.getDataType().equals(this.zzavT), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzavT});
            this.zzavU = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.zzavW = packageName;
            return this;
        }

        public Intent build() {
            zzx.zza((this.zzRD > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzx.zza((this.zzavV > this.zzRD ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzavU.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzRD);
            intent.putExtra("vnd.google.fitness.end_time", this.zzavV);
            zzc.zza((SafeParcelable)this.zzavU, (Intent)intent, (String)"vnd.google.fitness.data_source");
            return this.zzl(intent);
        }

        private Intent zzl(Intent intent) {
            if (this.zzavW == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzavW);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzavW, string));
                return intent2;
            }
            return intent;
        }
    }
}

