/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzd;
import com.google.android.gms.internal.zzns;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzavU;
    private long zzawj;
    private long zzawk;
    private final Value[] zzawl;
    private DataSource zzawm;
    private long zzawn;
    private long zzawo;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzd();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzavU = dataSource;
        this.zzawm = originalDataSource;
        this.zzawj = timestampNanos;
        this.zzawk = startTimeNanos;
        this.zzawl = values;
        this.zzawn = rawTimestamp;
        this.zzawo = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(DataPoint.zza(dataSources, rawDataPoint.zzaxg), DataPoint.zza(dataSources, rawDataPoint.zzaxh), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource originalDataSource, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzawj, 0L), DataPoint.zza(rawDataPoint.zzawk, 0L), rawDataPoint.zzawl, originalDataSource, DataPoint.zza(rawDataPoint.zzawn, 0L), DataPoint.zza(rawDataPoint.zzawo, 0L));
    }

    private static DataSource zza(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.mVersionCode = 4;
        this.zzavU = (DataSource)zzx.zzb((Object)dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzawl = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzawl[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzc.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.zzawj = timeUnit.toNanos(timestamp);
        if (this.zzue() && zzns.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzawj = zzns.zza(this.zzawj, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzue() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.zzawk = timeUnit.toNanos(startTime);
        this.zzawj = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzawl[n];
    }

    public Value[] zzuf() {
        return this.zzawl;
    }

    public DataPoint setFloatValues(float ... values) {
        this.zzeO(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzawl[i].setFloat(values[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.zzeO(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzawl[i].setInt(values[i]);
        }
        return this;
    }

    private void zzeO(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzx.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.zzavU.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzavU;
    }

    public DataSource getOriginalDataSource() {
        return this.zzawm != null ? this.zzawm : this.zzavU;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzawj, TimeUnit.NANOSECONDS);
    }

    public long zzug() {
        return this.zzawn;
    }

    public long zzuh() {
        return this.zzawo;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzawk, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzawj, TimeUnit.NANOSECONDS);
    }

    public void zzui() {
        DataSource dataSource = this.getDataSource();
        zzx.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzx.zzb((this.zzawj > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzx.zzb((this.zzawk <= this.zzawj ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DataPoint && this.zza((DataPoint)o);
    }

    private boolean zza(DataPoint dataPoint) {
        return zzw.equal((Object)this.zzavU, (Object)dataPoint.zzavU) && this.zzawj == dataPoint.zzawj && this.zzawk == dataPoint.zzawk && Arrays.equals(this.zzawl, dataPoint.zzawl) && zzw.equal((Object)this.getOriginalDataSource(), (Object)dataPoint.getOriginalDataSource());
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavU, this.zzawj, this.zzawk});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.zzawl), this.zzawk, this.zzawj, this.zzawn, this.zzawo, this.zzavU.toDebugString(), this.zzawm != null ? this.zzawm.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getTimestampNanos() {
        return this.zzawj;
    }

    public long zzuj() {
        return this.zzawk;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzd.zza(this, parcel, flags);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

