/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.internal.zznw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzavU;
    private final DataType zzavT;
    private final List<DataPoint> zzawp;
    private final List<DataSource> zzawq;
    private boolean zzawi = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zze();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzavU = dataSource;
        this.zzavT = dataSource.getDataType();
        this.zzawi = serverHasMoreData;
        this.zzawp = new ArrayList<DataPoint>(dataPoints.size());
        this.zzawq = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.zzawp.add(new DataPoint(this.zzawq, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.mVersionCode = 3;
        this.zzavU = (DataSource)zzx.zzz((Object)dataSource);
        this.zzavT = dataSource.getDataType();
        this.zzawp = new ArrayList<DataPoint>();
        this.zzawq = new ArrayList<DataSource>();
        this.zzawq.add(this.zzavU);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources) {
        this.mVersionCode = 3;
        this.zzavU = DataSet.zzb(uniqueDataSources, dataSet.zzaxg);
        this.zzavT = this.zzavU.getDataType();
        this.zzawq = uniqueDataSources;
        this.zzawi = dataSet.zzawi;
        List<RawDataPoint> list = dataSet.zzaxj;
        this.zzawp = new ArrayList<DataPoint>(list.size());
        for (RawDataPoint rawDataPoint : list) {
            this.zzawp.add(new DataPoint(this.zzawq, rawDataPoint));
        }
    }

    private static <T> T zzb(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzx.zzb((Object)dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzavU);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzx.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzavU.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzavU});
        dataPoint.zzui();
        zznw.zze(dataPoint);
        this.zzb(dataPoint);
    }

    public void zzb(DataPoint dataPoint) {
        this.zzawp.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzawq.contains(dataSource)) {
            this.zzawq.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzavU;
    }

    public DataType getDataType() {
        return this.zzavU.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzawp);
    }

    public boolean isEmpty() {
        return this.zzawp.isEmpty();
    }

    public boolean zzuc() {
        return this.zzawi;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataSet && this.zza((DataSet)o);
    }

    private boolean zza(DataSet dataSet) {
        return zzw.equal((Object)this.getDataType(), (Object)dataSet.getDataType()) && zzw.equal((Object)this.zzavU, (Object)dataSet.zzavU) && zzw.equal(this.zzawp, dataSet.zzawp) && this.zzawi == dataSet.zzawi;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavU});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzuk();
        return String.format("DataSet{%s %s}", this.zzavU.toDebugString(), this.zzawp.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzawp.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawDataPoint> zzuk() {
        return this.zzv(this.zzawq);
    }

    List<RawDataPoint> zzv(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzawp.size());
        for (DataPoint dataPoint : this.zzawp) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzul() {
        return this.zzawq;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }
}

