/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzf;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int mVersionCode;
    private final DataType zzavT;
    private final String mName;
    private final int zzabB;
    private final Device zzawr;
    private final Application zzaws;
    private final String zzawt;
    private final String zzawu;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzf();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, Application application, String streamName) {
        this.mVersionCode = versionCode;
        this.zzavT = dataType;
        this.zzabB = type;
        this.mName = name;
        this.zzawr = device;
        this.zzaws = application;
        this.zzawt = streamName;
        this.zzawu = this.zzun();
    }

    private DataSource(Builder builder) {
        this.mVersionCode = 3;
        this.zzavT = builder.zzavT;
        this.zzabB = builder.zzabB;
        this.mName = builder.mName;
        this.zzawr = builder.zzawr;
        this.zzaws = builder.zzaws;
        this.zzawt = builder.zzawt;
        this.zzawu = this.zzun();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzavT;
    }

    public int getType() {
        return this.zzabB;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.zzaws == null ? null : this.zzaws.getPackageName();
    }

    public Application zzum() {
        return this.zzaws;
    }

    public Device getDevice() {
        return this.zzawr;
    }

    public String getStreamName() {
        return this.zzawt;
    }

    public String getStreamIdentifier() {
        return this.zzawu;
    }

    private String zzun() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzavT.getName());
        if (this.zzaws != null) {
            stringBuilder.append(":").append(this.zzaws.getPackageName());
        }
        if (this.zzawr != null) {
            stringBuilder.append(":").append(this.zzawr.getStreamIdentifier());
        }
        if (this.zzawt != null) {
            stringBuilder.append(":").append(this.zzawt);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.zza((DataSource)that);
    }

    private boolean zza(DataSource dataSource) {
        return this.zzawu.equals(dataSource.zzawu);
    }

    public int hashCode() {
        return this.zzawu.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.zzaws != null) {
            stringBuilder.append(":").append(this.zzaws);
        }
        if (this.zzawr != null) {
            stringBuilder.append(":").append(this.zzawr);
        }
        if (this.zzawt != null) {
            stringBuilder.append(":").append(this.zzawt);
        }
        stringBuilder.append(":").append(this.zzavT);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.zzabB == 0 ? "r" : "d") + ":" + this.zzavT.zzuo() + (this.zzaws == null ? "" : (this.zzaws.equals(Application.zzawa) ? ":gms" : ":" + this.zzaws.getPackageName())) + (this.zzawr != null ? ":" + this.zzawr.getModel() + ":" + this.zzawr.getUid() : "") + (this.zzawt != null ? ":" + this.zzawt : "");
    }

    private String getTypeString() {
        switch (this.zzabB) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzf.zza(this, parcel, flags);
    }

    public static final class Builder {
        private DataType zzavT;
        private int zzabB = -1;
        private String mName;
        private Device zzawr;
        private Application zzaws;
        private String zzawt = "";

        public Builder setDataType(DataType dataType) {
            this.zzavT = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.zzabB = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzawr = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.zzaws = Application.zzdn(packageName);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            zzx.zzb((streamName != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzawt = streamName;
            return this;
        }

        public DataSource build() {
            zzx.zza((this.zzavT != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzx.zza((this.zzabB >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

