/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzn;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@KeepName
public final class RawBucket
implements SafeParcelable {
    final int mVersionCode;
    public final long zzRD;
    public final long zzavV;
    public final Session zzavX;
    public final int zzaxf;
    public final List<RawDataSet> zzawg;
    public final int zzawh;
    public final boolean zzawi;
    public static final Parcelable.Creator<RawBucket> CREATOR = new zzn();

    public RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzRD = startTimeMillis;
        this.zzavV = endTimeMillis;
        this.zzavX = session;
        this.zzaxf = activity;
        this.zzawg = dataSets;
        this.zzawh = bucketType;
        this.zzawi = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.mVersionCode = 2;
        this.zzRD = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.zzavV = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.zzavX = bucket.getSession();
        this.zzaxf = bucket.zzub();
        this.zzawh = bucket.getBucketType();
        this.zzawi = bucket.zzuc();
        List<DataSet> list = bucket.getDataSets();
        this.zzawg = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.zzawg.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawBucket && this.zza((RawBucket)o);
    }

    private boolean zza(RawBucket rawBucket) {
        return this.zzRD == rawBucket.zzRD && this.zzavV == rawBucket.zzavV && this.zzaxf == rawBucket.zzaxf && zzw.equal(this.zzawg, rawBucket.zzawg) && this.zzawh == rawBucket.zzawh && this.zzawi == rawBucket.zzawi;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzRD, this.zzavV, this.zzawh});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("startTime", (Object)this.zzRD).zzg("endTime", (Object)this.zzavV).zzg("activity", (Object)this.zzaxf).zzg("dataSets", this.zzawg).zzg("bucketType", (Object)this.zzawh).zzg("serverHasMoreData", (Object)this.zzawi).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzn.zza(this, parcel, flags);
    }
}

