/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.zzq;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int mVersionCode;
    private final long zzRD;
    private final long zzavV;
    private final String mName;
    private final String zzaxk;
    private final String zzaxl;
    private final int zzawf;
    private final Application zzaws;
    private final Long zzaxm;
    public static final Parcelable.Creator<Session> CREATOR = new zzq();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzRD = startTimeMillis;
        this.zzavV = endTimeMillis;
        this.mName = name;
        this.zzaxk = identifier;
        this.zzaxl = description;
        this.zzawf = activityType;
        this.zzaws = application;
        this.zzaxm = activeTimeMillis;
    }

    public Session(long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, Application application, Long activeTimeMillis) {
        this(3, startTimeMillis, endTimeMillis, name, identifier, description, activityType, application, activeTimeMillis);
    }

    private Session(Builder builder) {
        this(builder.zzRD, builder.zzavV, builder.mName, builder.zzaxk, builder.zzaxl, builder.zzawf, builder.zzaws, builder.zzaxm);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzc.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzRD, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzavV, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzx.zza((this.zzaxm != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzaxm, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzaxm != null;
    }

    public boolean isOngoing() {
        return this.zzavV == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzaxk;
    }

    public String getDescription() {
        return this.zzaxl;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzawf);
    }

    public int zzub() {
        return this.zzawf;
    }

    public Application zzum() {
        return this.zzaws;
    }

    public String getAppPackageName() {
        return this.zzaws == null ? null : this.zzaws.getPackageName();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Session && this.zza((Session)o);
    }

    private boolean zza(Session session) {
        return this.zzRD == session.zzRD && this.zzavV == session.zzavV && zzw.equal((Object)this.mName, (Object)session.mName) && zzw.equal((Object)this.zzaxk, (Object)session.zzaxk) && zzw.equal((Object)this.zzaxl, (Object)session.zzaxl) && zzw.equal((Object)this.zzaws, (Object)session.zzaws) && this.zzawf == session.zzawf;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzRD, this.zzavV, this.zzaxk});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("startTime", (Object)this.zzRD).zzg("endTime", (Object)this.zzavV).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzaxk).zzg("description", (Object)this.zzaxl).zzg("activity", (Object)this.zzawf).zzg("application", (Object)this.zzaws).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzlO() {
        return this.zzRD;
    }

    public long zzud() {
        return this.zzavV;
    }

    public Long zzuw() {
        return this.zzaxm;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzq.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzRD = 0L;
        private long zzavV = 0L;
        private String mName = null;
        private String zzaxk;
        private String zzaxl;
        private int zzawf = 4;
        private Application zzaws;
        private Long zzaxm;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            zzx.zza((time > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzRD = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            zzx.zza((time >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzavV = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            zzx.zzb((name.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            zzx.zzac((identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0 ? 1 : 0) != 0);
            this.zzaxk = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            zzx.zzb((description.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzaxl = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.zzfa(FitnessActivities.zzdm(activity));
        }

        public Builder zzfa(int n) {
            this.zzawf = n;
            return this;
        }

        public Builder setActiveTime(long time, TimeUnit timeUnit) {
            this.zzaxm = timeUnit.toMillis(time);
            return this;
        }

        public Session build() {
            zzx.zza((this.zzRD > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzx.zza((this.zzavV == 0L || this.zzavV > this.zzRD ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzaxk == null) {
                this.zzaxk = (this.mName == null ? "" : this.mName) + this.zzRD;
            }
            return new Session(this);
        }
    }
}

