/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzk;
import com.google.android.gms.fitness.request.SensorRequest;
import com.google.android.gms.fitness.request.zzv;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.location.LocationRequest;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SensorRegistrationRequest
implements SafeParcelable {
    private final int mVersionCode;
    private DataSource zzavU;
    private DataType zzavT;
    private zzk zzaBh;
    int zzaBi;
    int zzaBj;
    private final long zzaxo;
    private final long zzaBk;
    private final PendingIntent mPendingIntent;
    private final long zzaBl;
    private final int zzaxp;
    private final List<LocationRequest> zzaBm;
    private final long zzaBn;
    private final List<Object> zzaBo;
    private final zzow zzaAD;
    public static final Parcelable.Creator<SensorRegistrationRequest> CREATOR = new zzv();

    SensorRegistrationRequest(int versionCode, DataSource dataSource, DataType dataType, IBinder listenerBinder, int samplingIntervalMicrosInt, int maxDeliveryLatencyMicrosInt, long samplingIntervalMicros, long maxDeliveryLatencyMicros, PendingIntent intent, long fastestIntervalMicros, int accuracyMode, List<LocationRequest> locationRequests, long registrationTimeOutMicros, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzavU = dataSource;
        this.zzavT = dataType;
        this.zzaBh = listenerBinder == null ? null : zzk.zza.zzbt(listenerBinder);
        this.zzaxo = samplingIntervalMicros == 0L ? (long)samplingIntervalMicrosInt : samplingIntervalMicros;
        this.zzaBl = fastestIntervalMicros;
        this.zzaBk = maxDeliveryLatencyMicros == 0L ? (long)maxDeliveryLatencyMicrosInt : maxDeliveryLatencyMicros;
        this.zzaBm = locationRequests;
        this.mPendingIntent = intent;
        this.zzaxp = accuracyMode;
        this.zzaBo = Collections.emptyList();
        this.zzaBn = registrationTimeOutMicros;
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    public SensorRegistrationRequest(SensorRequest request, zzk listener, PendingIntent intent, zzow callback) {
        this(request.getDataSource(), request.getDataType(), listener, intent, request.getSamplingRate(TimeUnit.MICROSECONDS), request.getFastestRate(TimeUnit.MICROSECONDS), request.getMaxDeliveryLatency(TimeUnit.MICROSECONDS), request.getAccuracyMode(), null, Collections.emptyList(), request.zzvc(), callback);
    }

    public SensorRegistrationRequest(DataSource dataSource, DataType dataType, zzk listener, PendingIntent pendingIntent, long samplingIntervalMicros, long fastestIntervalMicros, long maxDeliveryLatencyMicros, int accuracyMode, List<LocationRequest> locationRequests, List<Object> clientIdentities, long registrationTimeOutMicros, zzow callback) {
        this.mVersionCode = 6;
        this.zzavU = dataSource;
        this.zzavT = dataType;
        this.zzaBh = listener;
        this.mPendingIntent = pendingIntent;
        this.zzaxo = samplingIntervalMicros;
        this.zzaBl = fastestIntervalMicros;
        this.zzaBk = maxDeliveryLatencyMicros;
        this.zzaxp = accuracyMode;
        this.zzaBm = locationRequests;
        this.zzaBo = clientIdentities;
        this.zzaBn = registrationTimeOutMicros;
        this.zzaAD = callback;
    }

    public DataSource getDataSource() {
        return this.zzavU;
    }

    public DataType getDataType() {
        return this.zzavT;
    }

    public PendingIntent getIntent() {
        return this.mPendingIntent;
    }

    public long zzuX() {
        return this.zzaBl;
    }

    public long zzux() {
        return this.zzaxo;
    }

    public long zzuY() {
        return this.zzaBk;
    }

    public List<LocationRequest> zzuZ() {
        return this.zzaBm;
    }

    public int getAccuracyMode() {
        return this.zzaxp;
    }

    public long zzva() {
        return this.zzaBn;
    }

    public IBinder getCallbackBinder() {
        return this.zzaAD == null ? null : this.zzaAD.asBinder();
    }

    public String toString() {
        return String.format("SensorRegistrationRequest{type %s source %s interval %s fastest %s latency %s}", this.zzavT, this.zzavU, this.zzaxo, this.zzaBl, this.zzaBk);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzvb() {
        return this.zzaBh == null ? null : this.zzaBh.asBinder();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzv.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRegistrationRequest && this.zzb((SensorRegistrationRequest)that);
    }

    private boolean zzb(SensorRegistrationRequest sensorRegistrationRequest) {
        return zzw.equal((Object)this.zzavU, (Object)sensorRegistrationRequest.zzavU) && zzw.equal((Object)this.zzavT, (Object)sensorRegistrationRequest.zzavT) && this.zzaxo == sensorRegistrationRequest.zzaxo && this.zzaBl == sensorRegistrationRequest.zzaBl && this.zzaBk == sensorRegistrationRequest.zzaBk && this.zzaxp == sensorRegistrationRequest.zzaxp && zzw.equal(this.zzaBm, sensorRegistrationRequest.zzaBm);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavU, this.zzavT, this.zzaBh, this.zzaxo, this.zzaBl, this.zzaBk, this.zzaxp, this.zzaBm});
    }
}

