/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzy;
import com.google.android.gms.internal.zzou;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final String zzaBu;
    private final String zzLq;
    private final long zzRD;
    private final long zzavV;
    private final List<DataType> zzawe;
    private final List<DataSource> zzaAF;
    private boolean zzaBv;
    private final boolean zzaAQ;
    private final List<String> zzaBw;
    private final zzou zzaBx;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzy();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzaBu = sessionName;
        this.zzLq = sessionId;
        this.zzRD = startTimeMillis;
        this.zzavV = endTimeMillis;
        this.zzawe = dataTypes;
        this.zzaAF = dataSources;
        this.zzaBv = getSessionsFromAllApps;
        this.zzaAQ = serverQueriesEnabled;
        this.zzaBw = excludedPackages;
        this.zzaBx = zzou.zza.zzbP(callback);
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzaBu, builder.zzLq, builder.zzRD, builder.zzavV, builder.zzawe, builder.zzaAF, builder.zzaBv, builder.zzaAQ, builder.zzaBw, null);
    }

    public SessionReadRequest(SessionReadRequest request, zzou callback) {
        this(request.zzaBu, request.zzLq, request.zzRD, request.zzavV, request.zzawe, request.zzaAF, request.zzaBv, request.zzaAQ, request.zzaBw, callback);
    }

    public SessionReadRequest(String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, zzou callback) {
        this(5, sessionName, sessionId, startTimeMillis, endTimeMillis, dataTypes, dataSources, getSessionsFromAllApps, serverQueriesEnabled, excludedPackages, callback == null ? null : callback.asBinder());
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzRD, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzavV, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzaBu;
    }

    public String getSessionId() {
        return this.zzLq;
    }

    public List<DataType> getDataTypes() {
        return this.zzawe;
    }

    public List<DataSource> getDataSources() {
        return this.zzaAF;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzaBv;
    }

    public List<String> getExcludedPackages() {
        return this.zzaBw;
    }

    public boolean zzuP() {
        return this.zzaAQ;
    }

    public long zzud() {
        return this.zzavV;
    }

    public long zzlO() {
        return this.zzRD;
    }

    public boolean zzve() {
        return this.zzaBv;
    }

    public IBinder getCallbackBinder() {
        return this.zzaBx == null ? null : this.zzaBx.asBinder();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SessionReadRequest && this.zzb((SessionReadRequest)o);
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzw.equal((Object)this.zzaBu, (Object)sessionReadRequest.zzaBu) && this.zzLq.equals(sessionReadRequest.zzLq) && this.zzRD == sessionReadRequest.zzRD && this.zzavV == sessionReadRequest.zzavV && zzw.equal(this.zzawe, sessionReadRequest.zzawe) && zzw.equal(this.zzaAF, sessionReadRequest.zzaAF) && this.zzaBv == sessionReadRequest.zzaBv && this.zzaBw.equals(sessionReadRequest.zzaBw) && this.zzaAQ == sessionReadRequest.zzaAQ;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaBu, this.zzLq, this.zzRD, this.zzavV});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("sessionName", (Object)this.zzaBu).zzg("sessionId", (Object)this.zzLq).zzg("startTimeMillis", (Object)this.zzRD).zzg("endTimeMillis", (Object)this.zzavV).zzg("dataTypes", this.zzawe).zzg("dataSources", this.zzaAF).zzg("sessionsFromAllApps", (Object)this.zzaBv).zzg("excludedPackages", this.zzaBw).zzg("useServer", (Object)this.zzaAQ).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzy.zza(this, dest, flags);
    }

    public static class Builder {
        private String zzaBu;
        private String zzLq;
        private long zzRD = 0L;
        private long zzavV = 0L;
        private List<DataType> zzawe = new ArrayList<DataType>();
        private List<DataSource> zzaAF = new ArrayList<DataSource>();
        private boolean zzaBv = false;
        private boolean zzaAQ = false;
        private List<String> zzaBw = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.zzRD = timeUnit.toMillis(startTime);
            this.zzavV = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.zzaBu = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.zzLq = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            if (!this.zzaAF.contains(dataSource)) {
                this.zzaAF.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            if (!this.zzawe.contains(dataType)) {
                this.zzawe.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzaBv = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            zzx.zzb((Object)appPackageName, (Object)"Attempting to use a null package name");
            if (!this.zzaBw.contains(appPackageName)) {
                this.zzaBw.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzaAQ = true;
            return this;
        }

        public SessionReadRequest build() {
            zzx.zzb((this.zzRD > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzRD});
            zzx.zzb((this.zzavV > 0L && this.zzavV > this.zzRD ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzavV});
            return new SessionReadRequest(this);
        }
    }
}

