/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzaa;
import com.google.android.gms.internal.zzow;
import java.util.concurrent.TimeUnit;

public class SessionStartRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final Session zzavX;
    private final zzow zzaAD;
    public static final Parcelable.Creator<SessionStartRequest> CREATOR = new zzaa();

    SessionStartRequest(int versionCode, Session session, IBinder callback) {
        this.mVersionCode = versionCode;
        this.zzavX = session;
        this.zzaAD = zzow.zza.zzbR(callback);
    }

    public SessionStartRequest(Session session, zzow callback) {
        zzx.zzb((session.getStartTime(TimeUnit.MILLISECONDS) < System.currentTimeMillis() ? 1 : 0) != 0, (Object)"Cannot start a session in the future");
        zzx.zzb((boolean)session.isOngoing(), (Object)"Cannot start a session which has already ended");
        this.mVersionCode = 3;
        this.zzavX = session;
        this.zzaAD = callback;
    }

    public Session getSession() {
        return this.zzavX;
    }

    public IBinder getCallbackBinder() {
        return this.zzaAD == null ? null : this.zzaAD.asBinder();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SessionStartRequest && this.zzb((SessionStartRequest)o);
    }

    private boolean zzb(SessionStartRequest sessionStartRequest) {
        return zzw.equal((Object)this.zzavX, (Object)sessionStartRequest.zzavX);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavX});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("session", (Object)this.zzavX).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzaa.zza(this, dest, flags);
    }
}

