/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<DataSet> zzawg;
    private final Status zzUX;
    private final List<Bucket> zzaBF;
    private int zzaBG;
    private final List<DataSource> zzawq;
    private final List<DataType> zzaBH;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.mVersionCode = versionCode;
        this.zzUX = status;
        this.zzaBG = batchCount;
        this.zzawq = uniqueDataSources;
        this.zzaBH = uniqueDataTypes;
        this.zzawg = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet object : dataSets) {
            this.zzawg.add(new DataSet(object, uniqueDataSources));
        }
        this.zzaBF = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.zzaBF.add(new Bucket(rawBucket, uniqueDataSources));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.mVersionCode = 5;
        this.zzawg = dataSets;
        this.zzUX = status;
        this.zzaBF = buckets;
        this.zzaBG = 1;
        this.zzawq = new ArrayList<DataSource>();
        this.zzaBH = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource object : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(object));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzawg) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzawg) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzawg;
    }

    public List<Bucket> getBuckets() {
        return this.zzaBF;
    }

    public int zzvj() {
        return this.zzaBG;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet object : dataReadResult.getDataSets()) {
            this.zza(object, this.zzawg);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzaBF);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzaBF.add(bucket);
    }

    public Status getStatus() {
        return this.zzUX;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.zzc((DataReadResult)that);
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzUX.equals((Object)dataReadResult.zzUX) && zzw.equal(this.zzawg, dataReadResult.zzawg) && zzw.equal(this.zzaBF, dataReadResult.zzaBF);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzUX, this.zzawg, this.zzaBF});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("status", (Object)this.zzUX).zzg("dataSets", this.zzawg.size() > 5 ? this.zzawg.size() + " data sets" : this.zzawg).zzg("buckets", this.zzaBF.size() > 5 ? this.zzaBF.size() + " buckets" : this.zzaBF).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawBucket> zzvk() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzaBF.size());
        for (Bucket bucket : this.zzaBF) {
            arrayList.add(new RawBucket(bucket, this.zzawq, this.zzaBH));
        }
        return arrayList;
    }

    List<RawDataSet> zzvl() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzawg.size());
        for (DataSet dataSet : this.zzawg) {
            arrayList.add(new RawDataSet(dataSet, this.zzawq, this.zzaBH));
        }
        return arrayList;
    }

    List<DataSource> zzul() {
        return this.zzawq;
    }

    List<DataType> zzvm() {
        return this.zzaBH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

