/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.SessionDataSet;
import com.google.android.gms.fitness.result.zzj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<Session> zzaAG;
    private final List<SessionDataSet> zzaBO;
    private final Status zzUX;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzj();

    SessionReadResult(int versionCode, List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.mVersionCode = versionCode;
        this.zzaAG = sessions;
        this.zzaBO = Collections.unmodifiableList(sessionDataSets);
        this.zzUX = status;
    }

    public SessionReadResult(List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.mVersionCode = 3;
        this.zzaAG = sessions;
        this.zzaBO = Collections.unmodifiableList(sessionDataSets);
        this.zzUX = status;
    }

    public static SessionReadResult zzU(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<SessionDataSet> arrayList2 = new ArrayList<SessionDataSet>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzaAG;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzx.zzb((boolean)this.zzaAG.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzaBO) {
            if (!zzw.equal((Object)session, (Object)sessionDataSet.getSession()) || !dataType.equals(sessionDataSet.getDataSet().getDataType())) continue;
            arrayList.add(sessionDataSet.getDataSet());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzx.zzb((boolean)this.zzaAG.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzaBO) {
            if (!zzw.equal((Object)session, (Object)sessionDataSet.getSession())) continue;
            arrayList.add(sessionDataSet.getDataSet());
        }
        return arrayList;
    }

    public List<SessionDataSet> zzvp() {
        return this.zzaBO;
    }

    public Status getStatus() {
        return this.zzUX;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SessionReadResult && this.zzb((SessionReadResult)that);
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.zzUX.equals((Object)sessionReadResult.zzUX) && zzw.equal(this.zzaAG, sessionReadResult.zzaAG) && zzw.equal(this.zzaBO, sessionReadResult.zzaBO);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzUX, this.zzaAG, this.zzaBO});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("status", (Object)this.zzUX).zzg("sessions", this.zzaAG).zzg("sessionDataSets", this.zzaBO).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }
}

