/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.zzk;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.zza;
import com.google.android.gms.fitness.service.zzb;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
implements SafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int mVersionCode;
    private final DataSource zzavU;
    private final zzk zzaBh;
    private final long zzaBR;
    private final long zzaBS;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new zza();

    FitnessSensorServiceRequest(int versionCode, DataSource dataSource, IBinder listenerBinder, long samplingRateMicros, long batchIntervalMicros) {
        this.mVersionCode = versionCode;
        this.zzavU = dataSource;
        this.zzaBh = zzk.zza.zzbt(listenerBinder);
        this.zzaBR = samplingRateMicros;
        this.zzaBS = batchIntervalMicros;
    }

    public DataSource getDataSource() {
        return this.zzavU;
    }

    public SensorEventDispatcher getDispatcher() {
        return new zzb(this.zzaBh);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.zzaBR == -1L ? -1L : timeUnit.convert(this.zzaBR, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaBS, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", this.zzavU);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzvb() {
        return this.zzaBh.asBinder();
    }

    public long zzux() {
        return this.zzaBR;
    }

    public long zzvs() {
        return this.zzaBS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zza.zza(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FitnessSensorServiceRequest && this.zza((FitnessSensorServiceRequest)that);
    }

    private boolean zza(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return zzw.equal((Object)this.zzavU, (Object)fitnessSensorServiceRequest.zzavU) && this.zzaBR == fitnessSensorServiceRequest.zzaBR && this.zzaBS == fitnessSensorServiceRequest.zzaBS;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavU, this.zzaBR, this.zzaBS});
    }
}

