/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends AbstractSafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int mVersionCode;
    private final long zzXy;
    private final long zzaCJ;
    private final Session zzaCL;
    private final int zzaCT;
    private final List<DataSet> zzaCU;
    private final int zzaCV;
    private boolean zzaCW = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zzc();

    Bucket(int n, long l, long l2, Session session, int n2, List<DataSet> list, int n3, boolean bl) {
        this.mVersionCode = n;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.zzaCL = session;
        this.zzaCT = n2;
        this.zzaCU = list;
        this.zzaCV = n3;
        this.zzaCW = bl;
    }

    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(2, rawBucket.zzXy, rawBucket.zzaCJ, rawBucket.zzaCL, rawBucket.zzaDT, Bucket.zza(rawBucket.zzaCU, list), rawBucket.zzaCV, rawBucket.zzaCW);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzXy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCJ, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzaCL;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzaCT);
    }

    public int zzxl() {
        return this.zzaCT;
    }

    public List<DataSet> getDataSets() {
        return this.zzaCU;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaCU) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzaCV;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Bucket && this.zza((Bucket)((Object)object));
    }

    private boolean zza(Bucket bucket) {
        return this.zzXy == bucket.zzXy && this.zzaCJ == bucket.zzaCJ && this.zzaCT == bucket.zzaCT && zzz.equal(this.zzaCU, bucket.zzaCU) && this.zzaCV == bucket.zzaCV && this.zzaCW == bucket.zzaCW;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzXy == bucket.zzXy && this.zzaCJ == bucket.zzaCJ && this.zzaCT == bucket.zzaCT && this.zzaCV == bucket.zzaCV;
    }

    public boolean zzxm() {
        if (this.zzaCW) {
            return true;
        }
        for (DataSet dataSet : this.zzaCU) {
            if (!dataSet.zzxm()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzXy, this.zzaCJ, this.zzaCT, this.zzaCV});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("startTime", (Object)this.zzXy).zzg("endTime", (Object)this.zzaCJ).zzg("activity", (Object)this.zzaCT).zzg("dataSets", this.zzaCU).zzg("bucketType", (Object)Bucket.zzfc(this.zzaCV)).zzg("serverHasMoreData", (Object)this.zzaCW).toString();
    }

    public static String zzfc(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzoq() {
        return this.zzXy;
    }

    public long zzxn() {
        return this.zzaCJ;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }
}

