/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zzrp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final long zzXy;
    private final long zzaCJ;
    private final List<DataSource> zzaHs;
    private final List<DataType> zzaCS;
    private final List<Session> zzaHt;
    private final boolean zzaHu;
    private final boolean zzaHv;
    private final zzrp zzaHq;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int n, long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.zzaHs = Collections.unmodifiableList(list);
        this.zzaCS = Collections.unmodifiableList(list2);
        this.zzaHt = list3;
        this.zzaHu = bl;
        this.zzaHv = bl2;
        this.zzaHq = zzrp.zza.zzbZ(iBinder);
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzXy, builder.zzaCJ, builder.zzaHs, builder.zzaCS, builder.zzaHt, builder.zzaHu, builder.zzaHv, null);
    }

    public DataDeleteRequest(DataDeleteRequest dataDeleteRequest, zzrp zzrp2) {
        this(dataDeleteRequest.zzXy, dataDeleteRequest.zzaCJ, dataDeleteRequest.zzaHs, dataDeleteRequest.zzaCS, dataDeleteRequest.zzaHt, dataDeleteRequest.zzaHu, dataDeleteRequest.zzaHv, zzrp2);
    }

    public DataDeleteRequest(long l, long l2, List<DataSource> list, List<DataType> list2, List<Session> list3, boolean bl, boolean bl2, zzrp zzrp2) {
        this.mVersionCode = 3;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.zzaHs = Collections.unmodifiableList(list);
        this.zzaCS = Collections.unmodifiableList(list2);
        this.zzaHt = list3;
        this.zzaHu = bl;
        this.zzaHv = bl2;
        this.zzaHq = zzrp2;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzXy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCJ, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzaHs;
    }

    public List<DataType> getDataTypes() {
        return this.zzaCS;
    }

    public List<Session> getSessions() {
        return this.zzaHt;
    }

    public boolean deleteAllData() {
        return this.zzaHu;
    }

    public boolean deleteAllSessions() {
        return this.zzaHv;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)((Object)object));
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzXy == dataDeleteRequest.zzXy && this.zzaCJ == dataDeleteRequest.zzaCJ && zzz.equal(this.zzaHs, dataDeleteRequest.zzaHs) && zzz.equal(this.zzaCS, dataDeleteRequest.zzaCS) && zzz.equal(this.zzaHt, dataDeleteRequest.zzaHt) && this.zzaHu == dataDeleteRequest.zzaHu && this.zzaHv == dataDeleteRequest.zzaHv;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzXy, this.zzaCJ});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("startTimeMillis", (Object)this.zzXy).zzg("endTimeMillis", (Object)this.zzaCJ).zzg("dataSources", this.zzaHs).zzg("dateTypes", this.zzaCS).zzg("sessions", this.zzaHt).zzg("deleteAllData", (Object)this.zzaHu).zzg("deleteAllSessions", (Object)this.zzaHv).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean zzxV() {
        return this.zzaHu;
    }

    public boolean zzxW() {
        return this.zzaHv;
    }

    public long zzxn() {
        return this.zzaCJ;
    }

    public long zzoq() {
        return this.zzXy;
    }

    public IBinder getCallbackBinder() {
        return this.zzaHq == null ? null : this.zzaHq.asBinder();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzXy;
        private long zzaCJ;
        private List<DataSource> zzaHs = new ArrayList<DataSource>();
        private List<DataType> zzaCS = new ArrayList<DataType>();
        private List<Session> zzaHt = new ArrayList<Session>();
        private boolean zzaHu = false;
        private boolean zzaHv = false;

        public Builder setTimeInterval(long l, long l2, TimeUnit timeUnit) {
            zzaa.zzb((l > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{l});
            zzaa.zzb((l2 > l ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{l2});
            this.zzXy = timeUnit.toMillis(l);
            this.zzaCJ = timeUnit.toMillis(l2);
            return this;
        }

        public Builder deleteAllData() {
            zzaa.zzb((boolean)this.zzaCS.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzaa.zzb((boolean)this.zzaHs.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzaHu = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzaa.zzb((!this.zzaHu ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzaa.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzaCS.contains((Object)dataType)) {
                this.zzaCS.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzaa.zzb((!this.zzaHu ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzaa.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzaHs.contains((Object)dataSource)) {
                this.zzaHs.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzaa.zzb((!this.zzaHv ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzaa.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzaa.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzaHt.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzaa.zzb((boolean)this.zzaHt.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzaHv = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzaa.zza((this.zzXy > 0L && this.zzaCJ > this.zzXy ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzaHu || !this.zzaHs.isEmpty() || !this.zzaCS.isEmpty();
            boolean bl2 = this.zzaHv || !this.zzaHt.isEmpty();
            zzaa.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzxX();
            return new DataDeleteRequest(this);
        }

        private void zzxX() {
            if (this.zzaHt.isEmpty()) {
                return;
            }
            for (Session session : this.zzaHt) {
                zzaa.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzXy && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzaCJ ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzXy, this.zzaCJ});
            }
        }
    }
}

